/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedLong;
import com.google.common.primitives.UnsignedLongs;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import com.google.re2j.PatternSyntaxException;
import dev.cel.common.CelErrorCode;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.internal.ComparisonFunctions;
import dev.cel.common.internal.DefaultMessageFactory;
import dev.cel.common.internal.DynamicProto;
import dev.cel.runtime.InterpreterException;
import dev.cel.runtime.Registrar;
import dev.cel.runtime.RuntimeEquality;
import dev.cel.runtime.RuntimeHelpers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Internal
public class StandardFunctions {
    private static final String UTC = "UTC";

    public static void add(Registrar registrar, DynamicProto dynamicProto, CelOptions celOptions) {
        RuntimeEquality runtimeEquality = new RuntimeEquality(dynamicProto);
        StandardFunctions.addNonInlined(registrar, runtimeEquality, celOptions);
        registrar.add("matches", String.class, String.class, (string, regexp) -> {
            try {
                return RuntimeHelpers.matches(string, regexp, celOptions);
            }
            catch (PatternSyntaxException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.INVALID_ARGUMENT).build();
            }
        });
        registrar.add("matches_string", String.class, String.class, (string, regexp) -> {
            try {
                return RuntimeHelpers.matches(string, regexp, celOptions);
            }
            catch (PatternSyntaxException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.INVALID_ARGUMENT).build();
            }
        });
        registrar.add("in_list", Object.class, List.class, (value, list) -> runtimeEquality.inList(list, value, celOptions));
        registrar.add("in_map", Object.class, Map.class, (key, map) -> runtimeEquality.inMap(map, key, celOptions));
    }

    public static void addNonInlined(Registrar registrar, CelOptions celOptions) {
        StandardFunctions.addNonInlined(registrar, new RuntimeEquality(DynamicProto.create(DefaultMessageFactory.INSTANCE)), celOptions);
    }

    public static void addNonInlined(Registrar registrar, RuntimeEquality runtimeEquality, CelOptions celOptions) {
        StandardFunctions.addBoolFunctions(registrar);
        StandardFunctions.addBytesFunctions(registrar);
        StandardFunctions.addDoubleFunctions(registrar, celOptions);
        StandardFunctions.addDurationFunctions(registrar);
        StandardFunctions.addIntFunctions(registrar, celOptions);
        StandardFunctions.addListFunctions(registrar, runtimeEquality, celOptions);
        StandardFunctions.addMapFunctions(registrar, runtimeEquality, celOptions);
        StandardFunctions.addStringFunctions(registrar, celOptions);
        StandardFunctions.addTimestampFunctions(registrar);
        if (celOptions.enableUnsignedLongs()) {
            StandardFunctions.addUintFunctions(registrar, celOptions);
        } else {
            StandardFunctions.addSignedUintFunctions(registrar, celOptions);
        }
        if (celOptions.enableHeterogeneousNumericComparisons()) {
            StandardFunctions.addCrossTypeNumericFunctions(registrar);
        }
        StandardFunctions.addOptionalValueFunctions(registrar, runtimeEquality, celOptions);
        registrar.add("equals", Object.class, Object.class, (x, y) -> runtimeEquality.objectEquals(x, y, celOptions));
        registrar.add("not_equals", Object.class, Object.class, (x, y) -> !runtimeEquality.objectEquals(x, y, celOptions));
        registrar.add("to_dyn", Object.class, arg -> arg);
    }

    private static void addBoolFunctions(Registrar registrar) {
        registrar.add("logical_not", Boolean.class, x -> x == false);
        registrar.add("less_bool", Boolean.class, Boolean.class, (x, y) -> x == false && y != false);
        registrar.add("less_equals_bool", Boolean.class, Boolean.class, (x, y) -> x == false || y != false);
        registrar.add("greater_bool", Boolean.class, Boolean.class, (x, y) -> x != false && y == false);
        registrar.add("greater_equals_bool", Boolean.class, Boolean.class, (x, y) -> x != false || y == false);
    }

    private static void addBytesFunctions(Registrar registrar) {
        registrar.add("less_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare(x, y) < 0);
        registrar.add("less_equals_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare(x, y) <= 0);
        registrar.add("greater_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare(x, y) > 0);
        registrar.add("greater_equals_bytes", ByteString.class, ByteString.class, (x, y) -> ByteString.unsignedLexicographicalComparator().compare(x, y) >= 0);
        registrar.add("add_bytes", ByteString.class, ByteString.class, ByteString::concat);
        registrar.add("size_bytes", ByteString.class, bytes -> (long)bytes.size());
        registrar.add("bytes_size", ByteString.class, bytes -> (long)bytes.size());
        registrar.add("string_to_bytes", String.class, ByteString::copyFromUtf8);
    }

    private static void addDoubleFunctions(Registrar registrar, CelOptions celOptions) {
        registrar.add("less_double", Double.class, Double.class, (x, y) -> x < y);
        registrar.add("less_equals_double", Double.class, Double.class, (x, y) -> x <= y);
        registrar.add("greater_double", Double.class, Double.class, (x, y) -> x > y);
        registrar.add("greater_equals_double", Double.class, Double.class, (x, y) -> x >= y);
        registrar.add("add_double", Double.class, Double.class, (x, y) -> x + y);
        registrar.add("subtract_double", Double.class, Double.class, (x, y) -> x - y);
        registrar.add("multiply_double", Double.class, Double.class, (x, y) -> x * y);
        registrar.add("divide_double", Double.class, Double.class, (x, y) -> x / y);
        registrar.add("negate_double", Double.class, x -> -x.doubleValue());
        registrar.add("int64_to_double", Long.class, Long::doubleValue);
        if (celOptions.enableUnsignedLongs()) {
            registrar.add("uint64_to_double", UnsignedLong.class, UnsignedLong::doubleValue);
        } else {
            registrar.add("uint64_to_double", Long.class, arg -> UnsignedLong.fromLongBits((long)arg).doubleValue());
        }
        registrar.add("string_to_double", String.class, arg -> {
            try {
                return Double.parseDouble(arg);
            }
            catch (NumberFormatException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
    }

    private static void addDurationFunctions(Registrar registrar) {
        registrar.add("less_duration", Duration.class, Duration.class, (x, y) -> Durations.compare((Duration)x, (Duration)y) < 0);
        registrar.add("less_equals_duration", Duration.class, Duration.class, (x, y) -> Durations.compare((Duration)x, (Duration)y) <= 0);
        registrar.add("greater_duration", Duration.class, Duration.class, (x, y) -> Durations.compare((Duration)x, (Duration)y) > 0);
        registrar.add("greater_equals_duration", Duration.class, Duration.class, (x, y) -> Durations.compare((Duration)x, (Duration)y) >= 0);
        registrar.add("add_duration_duration", Duration.class, Duration.class, Durations::add);
        registrar.add("subtract_duration_duration", Duration.class, Duration.class, Durations::subtract);
        registrar.add("string_to_duration", String.class, d -> {
            try {
                return RuntimeHelpers.createDurationFromString(d);
            }
            catch (IllegalArgumentException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
        registrar.add("duration_to_hours", Duration.class, Durations::toHours);
        registrar.add("duration_to_minutes", Duration.class, Durations::toMinutes);
        registrar.add("duration_to_seconds", Duration.class, Durations::toSeconds);
        registrar.add("duration_to_milliseconds", Duration.class, arg -> Durations.toMillis((Duration)arg) % java.time.Duration.ofSeconds(1L).toMillis());
    }

    private static void addIntFunctions(Registrar registrar, CelOptions celOptions) {
        registrar.add("less_int64", Long.class, Long.class, (x, y) -> x < y);
        registrar.add("less_equals_int64", Long.class, Long.class, (x, y) -> x <= y);
        registrar.add("greater_int64", Long.class, Long.class, (x, y) -> x > y);
        registrar.add("greater_equals_int64", Long.class, Long.class, (x, y) -> x >= y);
        registrar.add("add_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Add(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("subtract_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Subtract(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("multiply_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Multiply(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("divide_int64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.int64Divide(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("modulo_int64", Long.class, Long.class, (x, y) -> {
            try {
                return x % y;
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("negate_int64", Long.class, x -> {
            try {
                return RuntimeHelpers.int64Negate(x, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        if (celOptions.enableUnsignedLongs()) {
            registrar.add("uint64_to_int64", UnsignedLong.class, arg -> {
                if (arg.compareTo(UnsignedLong.valueOf((long)Long.MAX_VALUE)) > 0) {
                    throw new InterpreterException.Builder("unsigned out of int range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build();
                }
                return arg.longValue();
            });
        } else {
            registrar.add("uint64_to_int64", Long.class, arg -> {
                if (celOptions.errorOnIntWrap() && arg < 0L) {
                    throw new InterpreterException.Builder("unsigned out of int range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build();
                }
                return arg;
            });
        }
        registrar.add("double_to_int64", Double.class, arg -> {
            if (celOptions.errorOnIntWrap()) {
                return RuntimeHelpers.doubleToLongChecked(arg).orElseThrow(() -> new InterpreterException.Builder("double is out of range for int", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build());
            }
            return arg.longValue();
        });
        registrar.add("string_to_int64", String.class, arg -> {
            try {
                return Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
        registrar.add("timestamp_to_int64", Timestamp.class, Timestamps::toSeconds);
    }

    private static void addListFunctions(Registrar registrar, RuntimeEquality runtimeEquality, CelOptions celOptions) {
        registrar.add("add_list", List.class, List.class, RuntimeHelpers::concat);
        registrar.add("index_list", List.class, Number.class, RuntimeHelpers::indexList);
        registrar.add("size_list", List.class, list1 -> (long)list1.size());
        registrar.add("list_size", List.class, list1 -> (long)list1.size());
        registrar.add("in_function_list", List.class, Object.class, (list, value) -> runtimeEquality.inList(list, value, celOptions));
    }

    private static void addMapFunctions(Registrar registrar, RuntimeEquality runtimeEquality, CelOptions celOptions) {
        registrar.add("index_map", Map.class, Object.class, (map, key) -> runtimeEquality.indexMap(map, key, celOptions));
        registrar.add("size_map", Map.class, map1 -> (long)map1.size());
        registrar.add("map_size", Map.class, map1 -> (long)map1.size());
        registrar.add("in_function_map", Map.class, Object.class, (map, key) -> runtimeEquality.inMap(map, key, celOptions));
    }

    private static void addStringFunctions(Registrar registrar, CelOptions celOptions) {
        registrar.add("less_string", String.class, String.class, (x, y) -> x.compareTo((String)y) < 0);
        registrar.add("less_equals_string", String.class, String.class, (x, y) -> x.compareTo((String)y) <= 0);
        registrar.add("greater_string", String.class, String.class, (x, y) -> x.compareTo((String)y) > 0);
        registrar.add("greater_equals_string", String.class, String.class, (x, y) -> x.compareTo((String)y) >= 0);
        registrar.add("add_string", String.class, String.class, (x, y) -> x + y);
        registrar.add("size_string", String.class, s -> (long)s.codePointCount(0, s.length()));
        registrar.add("string_size", String.class, s -> (long)s.codePointCount(0, s.length()));
        registrar.add("contains_string", String.class, String.class, String::contains);
        registrar.add("ends_with_string", String.class, String.class, String::endsWith);
        registrar.add("starts_with_string", String.class, String.class, String::startsWith);
        registrar.add("int64_to_string", Long.class, arg -> arg.toString());
        if (celOptions.enableUnsignedLongs()) {
            registrar.add("uint64_to_string", UnsignedLong.class, UnsignedLong::toString);
        } else {
            registrar.add("uint64_to_string", Long.class, UnsignedLongs::toString);
        }
        registrar.add("double_to_string", Double.class, arg -> arg.toString());
        registrar.add("bytes_to_string", ByteString.class, ByteString::toStringUtf8);
        registrar.add("timestamp_to_string", Timestamp.class, Timestamps::toString);
        registrar.add("duration_to_string", Duration.class, Durations::toString);
    }

    private static void addTimestampFunctions(Registrar registrar) {
        registrar.add("less_timestamp", Timestamp.class, Timestamp.class, (x, y) -> Timestamps.compare((Timestamp)x, (Timestamp)y) < 0);
        registrar.add("less_equals_timestamp", Timestamp.class, Timestamp.class, (x, y) -> Timestamps.compare((Timestamp)x, (Timestamp)y) <= 0);
        registrar.add("greater_timestamp", Timestamp.class, Timestamp.class, (x, y) -> Timestamps.compare((Timestamp)x, (Timestamp)y) > 0);
        registrar.add("greater_equals_timestamp", Timestamp.class, Timestamp.class, (x, y) -> Timestamps.compare((Timestamp)x, (Timestamp)y) >= 0);
        registrar.add("add_timestamp_duration", Timestamp.class, Duration.class, Timestamps::add);
        registrar.add("add_duration_timestamp", Duration.class, Timestamp.class, (x, y) -> Timestamps.add((Timestamp)y, (Duration)x));
        registrar.add("subtract_timestamp_timestamp", Timestamp.class, Timestamp.class, (x, y) -> Timestamps.between((Timestamp)y, (Timestamp)x));
        registrar.add("subtract_timestamp_duration", Timestamp.class, Duration.class, Timestamps::subtract);
        registrar.add("string_to_timestamp", String.class, ts -> {
            try {
                return Timestamps.parse((String)ts);
            }
            catch (ParseException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
        registrar.add("int64_to_timestamp", Long.class, Timestamps::fromSeconds);
        registrar.add("timestamp_to_year", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getYear());
        registrar.add("timestamp_to_year_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getYear());
        registrar.add("timestamp_to_month", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getMonthValue() - 1L);
        registrar.add("timestamp_to_month_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getMonthValue() - 1L);
        registrar.add("timestamp_to_day_of_year", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getDayOfYear() - 1L);
        registrar.add("timestamp_to_day_of_year_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getDayOfYear() - 1L);
        registrar.add("timestamp_to_day_of_month", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getDayOfMonth() - 1L);
        registrar.add("timestamp_to_day_of_month_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getDayOfMonth() - 1L);
        registrar.add("timestamp_to_day_of_month_1_based", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getDayOfMonth());
        registrar.add("timestamp_to_day_of_month_1_based_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getDayOfMonth());
        registrar.add("timestamp_to_day_of_week", Timestamp.class, ts -> {
            DayOfWeek dayOfWeek = StandardFunctions.newLocalDateTime(ts, UTC).getDayOfWeek();
            return (long)dayOfWeek.getValue() % 7L;
        });
        registrar.add("timestamp_to_day_of_week_with_tz", Timestamp.class, String.class, (ts, tz) -> {
            DayOfWeek dayOfWeek = StandardFunctions.newLocalDateTime(ts, tz).getDayOfWeek();
            return (long)dayOfWeek.getValue() % 7L;
        });
        registrar.add("timestamp_to_hours", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getHour());
        registrar.add("timestamp_to_hours_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getHour());
        registrar.add("timestamp_to_minutes", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getMinute());
        registrar.add("timestamp_to_minutes_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getMinute());
        registrar.add("timestamp_to_seconds", Timestamp.class, ts -> (long)StandardFunctions.newLocalDateTime(ts, UTC).getSecond());
        registrar.add("timestamp_to_seconds_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)StandardFunctions.newLocalDateTime(ts, tz).getSecond());
        registrar.add("timestamp_to_milliseconds", Timestamp.class, ts -> (long)((double)StandardFunctions.newLocalDateTime(ts, UTC).getNano() / 1000000.0));
        registrar.add("timestamp_to_milliseconds_with_tz", Timestamp.class, String.class, (ts, tz) -> (long)((double)StandardFunctions.newLocalDateTime(ts, tz).getNano() / 1000000.0));
    }

    private static void addSignedUintFunctions(Registrar registrar, CelOptions celOptions) {
        registrar.add("less_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) < 0);
        registrar.add("less_equals_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) <= 0);
        registrar.add("greater_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) > 0);
        registrar.add("greater_equals_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y, celOptions) >= 0);
        registrar.add("add_uint64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Add(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("subtract_uint64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Subtract(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("multiply_uint64", Long.class, Long.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Multiply(x, y, celOptions);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("divide_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64Divide(x, y, celOptions));
        registrar.add("modulo_uint64", Long.class, Long.class, (x, y) -> RuntimeHelpers.uint64Mod(x, y, celOptions));
        registrar.add("int64_to_uint64", Long.class, arg -> {
            if (celOptions.errorOnIntWrap() && arg < 0L) {
                throw new InterpreterException.Builder("int out of uint range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build();
            }
            return arg;
        });
        registrar.add("double_to_uint64", Double.class, arg -> {
            if (celOptions.errorOnIntWrap()) {
                return RuntimeHelpers.doubleToUnsignedChecked(arg).map(UnsignedLong::longValue).orElseThrow(() -> new InterpreterException.Builder("double out of uint range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build());
            }
            return arg.longValue();
        });
        registrar.add("string_to_uint64", String.class, arg -> {
            try {
                return UnsignedLongs.parseUnsignedLong((String)arg);
            }
            catch (NumberFormatException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
    }

    private static void addUintFunctions(Registrar registrar, CelOptions celOptions) {
        registrar.add("less_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) < 0);
        registrar.add("less_equals_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) <= 0);
        registrar.add("greater_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) > 0);
        registrar.add("greater_equals_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> RuntimeHelpers.uint64CompareTo(x, y) >= 0);
        registrar.add("add_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Add(x, y);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("subtract_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Subtract(x, y);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("multiply_uint64", UnsignedLong.class, UnsignedLong.class, (x, y) -> {
            try {
                return RuntimeHelpers.uint64Multiply(x, y);
            }
            catch (ArithmeticException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(StandardFunctions.getArithmeticErrorCode(e)).build();
            }
        });
        registrar.add("divide_uint64", UnsignedLong.class, UnsignedLong.class, RuntimeHelpers::uint64Divide);
        registrar.add("modulo_uint64", UnsignedLong.class, UnsignedLong.class, RuntimeHelpers::uint64Mod);
        registrar.add("int64_to_uint64", Long.class, arg -> {
            if (celOptions.errorOnIntWrap() && arg < 0L) {
                throw new InterpreterException.Builder("int out of uint range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build();
            }
            return UnsignedLong.valueOf((long)arg);
        });
        registrar.add("double_to_uint64", Double.class, arg -> {
            if (celOptions.errorOnIntWrap()) {
                return RuntimeHelpers.doubleToUnsignedChecked(arg).orElseThrow(() -> new InterpreterException.Builder("double out of uint range", new Object[0]).setErrorCode(CelErrorCode.NUMERIC_OVERFLOW).build());
            }
            return UnsignedLong.valueOf((BigInteger)BigDecimal.valueOf(arg).toBigInteger());
        });
        registrar.add("string_to_uint64", String.class, arg -> {
            try {
                return UnsignedLong.valueOf((String)arg);
            }
            catch (NumberFormatException e) {
                throw new InterpreterException.Builder(e.getMessage(), new Object[0]).setCause(e).setErrorCode(CelErrorCode.BAD_FORMAT).build();
            }
        });
    }

    private static void addCrossTypeNumericFunctions(Registrar registrar) {
        registrar.add("less_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) == -1);
        registrar.add("less_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) == -1);
        registrar.add("less_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) == -1);
        registrar.add("less_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) == -1);
        registrar.add("less_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) == -1);
        registrar.add("less_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) == -1);
        registrar.add("less_equals_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) <= 0);
        registrar.add("less_equals_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) <= 0);
        registrar.add("less_equals_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) <= 0);
        registrar.add("less_equals_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) <= 0);
        registrar.add("less_equals_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) <= 0);
        registrar.add("less_equals_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) <= 0);
        registrar.add("greater_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) == 1);
        registrar.add("greater_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) == 1);
        registrar.add("greater_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) == 1);
        registrar.add("greater_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) == 1);
        registrar.add("greater_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) == 1);
        registrar.add("greater_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) == 1);
        registrar.add("greater_equals_int64_uint64", Long.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareIntUint(x, y) >= 0);
        registrar.add("greater_equals_uint64_int64", UnsignedLong.class, Long.class, (x, y) -> ComparisonFunctions.compareUintInt(x, y) >= 0);
        registrar.add("greater_equals_int64_double", Long.class, Double.class, (x, y) -> ComparisonFunctions.compareIntDouble(x, y) >= 0);
        registrar.add("greater_equals_double_int64", Double.class, Long.class, (x, y) -> ComparisonFunctions.compareDoubleInt(x, y) >= 0);
        registrar.add("greater_equals_uint64_double", UnsignedLong.class, Double.class, (x, y) -> ComparisonFunctions.compareUintDouble(x, y) >= 0);
        registrar.add("greater_equals_double_uint64", Double.class, UnsignedLong.class, (x, y) -> ComparisonFunctions.compareDoubleUint(x, y) >= 0);
    }

    private static void addOptionalValueFunctions(Registrar registrar, RuntimeEquality runtimeEquality, CelOptions options) {
        registrar.add("select_optional_field", Map.class, String.class, (map, key) -> runtimeEquality.findInMap((Map<?, ?>)map, key, options));
        registrar.add("map_optindex_optional_value", Map.class, Object.class, (map, key) -> runtimeEquality.findInMap((Map<?, ?>)map, key, options));
        registrar.add("optional_map_optindex_optional_value", Optional.class, Object.class, (optionalMap, key) -> StandardFunctions.indexOptionalMap(optionalMap, key, options, runtimeEquality));
        registrar.add("optional_map_index_value", Optional.class, Object.class, (optionalMap, key) -> StandardFunctions.indexOptionalMap(optionalMap, key, options, runtimeEquality));
        registrar.add("optional_list_index_int", Optional.class, Long.class, StandardFunctions::indexOptionalList);
        registrar.add("list_optindex_optional_int", List.class, Long.class, (list, index) -> {
            int castIndex = Ints.checkedCast((long)index);
            if (castIndex < 0 || castIndex >= list.size()) {
                return Optional.empty();
            }
            return Optional.of(list.get(castIndex));
        });
        registrar.add("optional_list_optindex_optional_int", Optional.class, Long.class, StandardFunctions::indexOptionalList);
    }

    private static Object indexOptionalMap(Optional<?> optionalMap, Object key, CelOptions options, RuntimeEquality runtimeEquality) {
        if (!optionalMap.isPresent()) {
            return Optional.empty();
        }
        Map map = (Map)optionalMap.get();
        return runtimeEquality.findInMap(map, key, options);
    }

    private static Object indexOptionalList(Optional<?> optionalList, long index) {
        if (!optionalList.isPresent()) {
            return Optional.empty();
        }
        List list = (List)optionalList.get();
        int castIndex = Ints.checkedCast((long)index);
        if (castIndex < 0 || castIndex >= list.size()) {
            return Optional.empty();
        }
        return Optional.of(list.get(castIndex));
    }

    private static ZoneId timeZone(String tz) throws InterpreterException {
        try {
            return ZoneId.of(tz);
        }
        catch (DateTimeException e) {
            try {
                int ind = tz.indexOf(":");
                if (ind == -1) {
                    throw new InterpreterException.Builder(e.getMessage(), new Object[0]).build();
                }
                int hourOffset = Integer.parseInt(tz.substring(0, ind));
                int minOffset = Integer.parseInt(tz.substring(ind + 1));
                String formattedOffset = (hourOffset < 0 ? "-" : "+") + String.format("%02d:%02d", Math.abs(hourOffset), minOffset);
                return ZoneId.of(formattedOffset);
            }
            catch (DateTimeException e2) {
                throw new InterpreterException.Builder(e2.getMessage(), new Object[0]).build();
            }
        }
    }

    private static LocalDateTime newLocalDateTime(Timestamp ts, String tz) throws InterpreterException {
        return Instant.ofEpochSecond(ts.getSeconds(), ts.getNanos()).atZone(StandardFunctions.timeZone(tz)).toLocalDateTime();
    }

    private static CelErrorCode getArithmeticErrorCode(ArithmeticException e) {
        String exceptionMessage = e.getMessage();
        if (exceptionMessage.equals("/ by zero")) {
            return CelErrorCode.DIVIDE_BY_ZERO;
        }
        return CelErrorCode.NUMERIC_OVERFLOW;
    }

    private StandardFunctions() {
    }
}

