/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.UnsignedLong;
import com.google.errorprone.annotations.Immutable;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.NullValue;
import dev.cel.common.CelOptions;
import dev.cel.common.annotations.Internal;
import dev.cel.common.types.CelKind;
import dev.cel.common.types.CelType;
import dev.cel.common.types.TypeType;
import dev.cel.expr.Type;
import dev.cel.expr.Value;
import dev.cel.runtime.TypeResolver;
import java.util.Collection;
import java.util.Map;
import org.jspecify.nullness.Nullable;

@Immutable
@Internal
public final class StandardTypeResolver
implements TypeResolver {
    private static final TypeResolver INSTANCE = new StandardTypeResolver(StandardTypeResolver.commonTypes(false));
    private static final TypeResolver INSTANCE_WITH_UNSIGNED_LONGS = new StandardTypeResolver(StandardTypeResolver.commonTypes(true));
    private static final Value TYPE_VALUE = StandardTypeResolver.createType("type");
    private final ImmutableMap<Value, Class<?>> types;

    public static TypeResolver getInstance(CelOptions celOptions) {
        return celOptions.enableUnsignedLongs() ? INSTANCE_WITH_UNSIGNED_LONGS : INSTANCE;
    }

    private static ImmutableMap<Value, Class<?>> commonTypes(boolean unsignedLongs) {
        return ImmutableMap.builder().put((Object)StandardTypeResolver.createType("bool"), Boolean.class).put((Object)StandardTypeResolver.createType("bytes"), ByteString.class).put((Object)StandardTypeResolver.createType("double"), Double.class).put((Object)StandardTypeResolver.createType("int"), Long.class).put((Object)StandardTypeResolver.createType("uint"), unsignedLongs ? UnsignedLong.class : Long.class).put((Object)StandardTypeResolver.createType("string"), String.class).put((Object)StandardTypeResolver.createType("null_type"), NullValue.class).put((Object)StandardTypeResolver.createType("list"), Collection.class).put((Object)StandardTypeResolver.createType("map"), Map.class).buildOrThrow();
    }

    private StandardTypeResolver(ImmutableMap<Value, Class<?>> types) {
        this.types = types;
    }

    @Override
    public @Nullable Value resolveObjectType(Object obj, @Nullable Value checkedTypeValue) {
        if (checkedTypeValue != null && (obj instanceof Long || obj instanceof NullValue)) {
            return checkedTypeValue;
        }
        return this.resolveObjectType(obj);
    }

    private @Nullable Value resolveObjectType(Object obj) {
        Value objVal;
        for (Value type : this.types.keySet()) {
            Class impl = (Class)this.types.get((Object)type);
            if (!impl.isInstance(obj)) continue;
            return type;
        }
        if (obj instanceof Value && (objVal = (Value)obj).getKindCase() == Value.KindCase.TYPE_VALUE) {
            return TYPE_VALUE;
        }
        if (obj instanceof MessageOrBuilder) {
            MessageOrBuilder msg = (MessageOrBuilder)obj;
            return StandardTypeResolver.createType(msg.getDescriptorForType().getFullName());
        }
        return null;
    }

    @Override
    public @Nullable Value adaptType(CelType type) {
        Preconditions.checkNotNull((Object)type);
        Value.Builder typeValue = Value.newBuilder();
        switch (type.kind()) {
            case OPAQUE: 
            case STRUCT: {
                return typeValue.setTypeValue(type.name()).build();
            }
            case LIST: {
                return typeValue.setTypeValue("list").build();
            }
            case MAP: {
                return typeValue.setTypeValue("map").build();
            }
            case TYPE: {
                CelType typeOfType = ((TypeType)type).type();
                if (typeOfType.kind() == CelKind.DYN) {
                    return typeValue.setTypeValue("type").build();
                }
                return this.adaptType(typeOfType);
            }
            case NULL_TYPE: {
                return typeValue.setTypeValue("null_type").build();
            }
            case DURATION: {
                return typeValue.setTypeValue("google.protobuf.Duration").build();
            }
            case TIMESTAMP: {
                return typeValue.setTypeValue("google.protobuf.Timestamp").build();
            }
            case BOOL: {
                return typeValue.setTypeValue("bool").build();
            }
            case BYTES: {
                return typeValue.setTypeValue("bytes").build();
            }
            case DOUBLE: {
                return typeValue.setTypeValue("double").build();
            }
            case INT: {
                return typeValue.setTypeValue("int").build();
            }
            case STRING: {
                return typeValue.setTypeValue("string").build();
            }
            case UINT: {
                return typeValue.setTypeValue("uint").build();
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public @Nullable Value adaptType(@Nullable Type type) {
        if (type == null) {
            return null;
        }
        Value.Builder typeValue = Value.newBuilder();
        switch (type.getTypeKindCase()) {
            case ABSTRACT_TYPE: {
                return typeValue.setTypeValue(type.getAbstractType().getName()).build();
            }
            case MESSAGE_TYPE: {
                return typeValue.setTypeValue(type.getMessageType()).build();
            }
            case LIST_TYPE: {
                return typeValue.setTypeValue("list").build();
            }
            case MAP_TYPE: {
                return typeValue.setTypeValue("map").build();
            }
            case TYPE: {
                Type typeOfType = type.getType();
                if (typeOfType.getTypeKindCase() == Type.TypeKindCase.DYN) {
                    return typeValue.setTypeValue("type").build();
                }
                return this.adaptType(typeOfType);
            }
            case NULL: {
                return typeValue.setTypeValue("null_type").build();
            }
            case PRIMITIVE: {
                return StandardTypeResolver.adaptPrimitive(type.getPrimitive());
            }
            case WRAPPER: {
                return StandardTypeResolver.adaptPrimitive(type.getWrapper());
            }
            case WELL_KNOWN: {
                switch (type.getWellKnown()) {
                    case DURATION: {
                        return typeValue.setTypeValue("google.protobuf.Duration").build();
                    }
                    case TIMESTAMP: {
                        return typeValue.setTypeValue("google.protobuf.Timestamp").build();
                    }
                }
                break;
            }
        }
        return null;
    }

    private static @Nullable Value adaptPrimitive(Type.PrimitiveType primitiveType) {
        Value.Builder typeValue = Value.newBuilder();
        switch (primitiveType) {
            case BOOL: {
                return typeValue.setTypeValue("bool").build();
            }
            case BYTES: {
                return typeValue.setTypeValue("bytes").build();
            }
            case DOUBLE: {
                return typeValue.setTypeValue("double").build();
            }
            case INT64: {
                return typeValue.setTypeValue("int").build();
            }
            case STRING: {
                return typeValue.setTypeValue("string").build();
            }
            case UINT64: {
                return typeValue.setTypeValue("uint").build();
            }
        }
        return null;
    }

    private static Value createType(String name) {
        return Value.newBuilder().setTypeValue(name).build();
    }
}

