/*
 * Decompiled with CFR 0.152.
 */
package dev.cel.runtime;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import dev.cel.runtime.CelAttribute;
import dev.cel.runtime.CelAttributePattern;
import dev.cel.runtime.CelAttributeResolver;
import dev.cel.runtime.CelUnknownSet;
import dev.cel.runtime.CelVariableResolver;
import dev.cel.runtime.GlobalResolver;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

@Immutable
public class UnknownContext {
    private final ImmutableList<CelAttributePattern> unresolvedAttributes;
    private final GlobalResolver variableResolver;
    private final ImmutableMap<CelAttribute, Object> resolvedAttributes;

    private UnknownContext(GlobalResolver resolver, ImmutableList<CelAttributePattern> unresolvedAttributes, ImmutableMap<CelAttribute, Object> resolvedAttributes) {
        this.unresolvedAttributes = unresolvedAttributes;
        this.variableResolver = resolver;
        this.resolvedAttributes = resolvedAttributes;
    }

    public static UnknownContext create(GlobalResolver resolver) {
        return new UnknownContext(resolver, (ImmutableList<CelAttributePattern>)ImmutableList.of(), (ImmutableMap<CelAttribute, Object>)ImmutableMap.of());
    }

    public static UnknownContext create(CelVariableResolver resolver, Collection<CelAttributePattern> attributes) {
        return new UnknownContext(UnknownContext.createExprVariableResolver(resolver), (ImmutableList<CelAttributePattern>)ImmutableList.copyOf(attributes), (ImmutableMap<CelAttribute, Object>)ImmutableMap.of());
    }

    private static GlobalResolver createExprVariableResolver(CelVariableResolver resolver) {
        return name -> resolver.find(name).orElse(null);
    }

    public CelAttributeResolver createAttributeResolver() {
        return DefaultAttributeResolver.create((ImmutableList<CelAttributePattern>)this.unresolvedAttributes, (ImmutableMap<CelAttribute, Object>)this.resolvedAttributes);
    }

    public GlobalResolver variableResolver() {
        return this.variableResolver;
    }

    public UnknownContext withResolvedAttributes(Map<CelAttribute, Object> resolvedAttributes) {
        return new UnknownContext(this.variableResolver, (ImmutableList<CelAttributePattern>)((ImmutableList)this.unresolvedAttributes.stream().filter(pattern -> !this.patternMaskedByResolvedAttribute(resolvedAttributes, (CelAttributePattern)pattern)).collect(ImmutableList.toImmutableList())), (ImmutableMap<CelAttribute, Object>)ImmutableMap.builder().putAll(this.resolvedAttributes).putAll(resolvedAttributes).buildOrThrow());
    }

    private boolean patternMaskedByResolvedAttribute(Map<CelAttribute, Object> resolved, CelAttributePattern pattern) {
        return resolved.keySet().stream().anyMatch(pattern::isPartialMatch);
    }

    private static class DefaultAttributeResolver
    implements CelAttributeResolver {
        private final ImmutableList<CelAttributePattern> unresolvedAttributes;
        private final ImmutableMap<CelAttribute, Object> resolvedAttributes;

        private DefaultAttributeResolver(ImmutableList<CelAttributePattern> unresolvedAttributes, ImmutableMap<CelAttribute, Object> resolvedAttributes) {
            this.unresolvedAttributes = unresolvedAttributes;
            this.resolvedAttributes = resolvedAttributes;
        }

        private static DefaultAttributeResolver create(ImmutableList<CelAttributePattern> attributes, ImmutableMap<CelAttribute, Object> resolvedAttributes) {
            return new DefaultAttributeResolver(attributes, resolvedAttributes);
        }

        @Override
        public Optional<Object> resolve(CelAttribute attribute) {
            Object entry = this.resolvedAttributes.get((Object)attribute);
            if (entry != null) {
                return Optional.of(entry);
            }
            return this.unresolvedAttributes.stream().filter(pattern -> pattern.isMatch(attribute)).findFirst().map(p -> CelUnknownSet.create(p.simplify(attribute)));
        }

        @Override
        public Optional<CelUnknownSet> maybePartialUnknown(CelAttribute attribute) {
            return this.unresolvedAttributes.stream().filter(p -> p.isPartialMatch(attribute)).findFirst().map(p -> CelUnknownSet.create(p.simplify(attribute)));
        }
    }
}

