package dev.coderoutine.tabulate

import kotlin.math.max

internal class ColumnSpec<T>(
    val header: String,
    val align: Align,
    val alignHeader: Align,
    val padWith: String,
    var width: Int,
    var minWidth: Int,
    var maxWidth: Int,
    val format: (T, String) -> Any,
    var onNull: () -> Any?,
    val valueProvider: (T) -> Any?,
) {
    val values = mutableListOf<String>()

    /**
     * Updates the width of this column and makes sure that [minWidth]
     * and [maxWidth] are taken into account.
     *
     * @return `true` if [maxWidth] was reached, allowing an early quit of measurement, `false` otherwise.
     */
    fun updateWidthWithinConstraints(value: Int): Boolean {
        width = max(width, max(minWidth, value))

        if (width >= maxWidth) {
            width = maxWidth
            return true
        }

        return false
    }
}