package dev.coderoutine.tabulate

private fun <T> Data<T>.tabulate(
    configure: TableScope<T>.() -> Unit,
): Iterator<String> {
    val scope = TableScope<T>()
    scope.configure()
    scope.measureColumns(this)
    return scope.rowIterator()
}

fun <T> Iterable<T>.tabulatingIterator(
    configure: TableScope<T>.() -> Unit,
): Iterator<String> = MultiIterableData(this).tabulate(configure)

fun <T> Iterable<T>.tabulateAsSequence(
    configure: TableScope<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Iterable<T>.tabulate(
    configure: TableScope<T>.() -> Unit,
): List<String> = this.tabulateAsSequence(configure).toList()

fun <T> Iterator<T>.tabulate(
    configure: TableScope<T>.() -> Unit,
): Iterator<String> = OnceOnlyIterableData(this).tabulate(configure)

fun <T> Sequence<T>.tabulatingIterator(
    configure: TableScope<T>.() -> Unit,
): Iterator<String> = this.iterator().tabulate(configure)

fun <T> Sequence<T>.tabulate(
    configure: TableScope<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Array<T>.tabulatingIterator(
    configure: TableScope<T>.() -> Unit,
): Iterator<String> = MultiIterableData(this.asIterable()).tabulate(configure)

fun <T> Array<T>.tabulateAsSequence(
    configure: TableScope<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Array<T>.tabulate(
    configure: TableScope<T>.() -> Unit,
): List<String> = this.tabulateAsSequence(configure).toList()