package dev.coderoutine.tabulate

import kotlin.math.max

internal class ColumnSpec<T> (
    val header: Any,
    val align: Align,
    val alignHeader: Align,
    val padWith: String,
    var width: Int,
    val minWidth: Int,
    val maxWidth: Int,
    val onNull: () -> Any?,
    val footer: Any,
    val ignoreAnsiEscapeSequences: Boolean,
    val valueProvider: (T) -> Any?,
) {
    val values = mutableListOf<Any?>()

    fun updateWidthWithinConstraints(value: Any?): Boolean {
        val valueAsString = value?.toString() ?: onNull().toString()

        val length = if(ignoreAnsiEscapeSequences) {
            valueAsString.length
        } else {
            valueAsString.lengthWithoutAnsiEscapeChars
        }

        return updateWidthWithinConstraints(length)
    }

    /**
     * Updates the width of this column and makes sure that [minWidth]
     * and [maxWidth] are taken into account.
     * @return `true` if [maxWidth] was reached, allowing an early quit of measurement, `false` otherwise.
     */
    fun updateWidthWithinConstraints(value: Int): Boolean {
        width = max(width, max(minWidth, value))

        if (width >= maxWidth) {
            width = maxWidth
            return true
        }

        return false
    }
}