package dev.coderoutine.tabulate

import dev.coderoutine.tabulate.Align.*
import java.time.temporal.Temporal

internal fun StringBuilder.appendN(n: Int, char: String) {
    repeat(n) { append(char) }
}

internal fun StringBuilder.appendAligned(
    align: Align,
    paddingWidth: Int,
    padWith: String,
    valueAsString: String,
    originalValue: Any?,
) {
    when (align) {
        LEFT -> {
            append(valueAsString)
            repeat(paddingWidth) { append(padWith) }
        }

        RIGHT -> {
            repeat(paddingWidth) { append(padWith) }
            append(valueAsString)
        }

        DYNAMIC -> when(originalValue) {
            is Number, is Temporal -> appendAligned(RIGHT, paddingWidth, padWith, valueAsString, originalValue)
            else -> appendAligned(LEFT, paddingWidth, padWith, valueAsString, originalValue)
        }
    }
}