package dev.coderoutine.tabulate

private fun <T> Data<T>.tabulate(
    configure: TableSpec<T>.() -> Unit,
): Iterator<String> {
    val spec = TableSpec<T>()
    spec.configure()
    spec.measureColumns(this)
    return TableLinesIterator(spec, outputIterator())
}

fun <T> Iterable<T>.tabulatingIterator(
    configure: TableSpec<T>.() -> Unit,
): Iterator<String> = MultiIterableData(this).tabulate(configure)

fun <T> Iterable<T>.tabulateAsSequence(
    configure: TableSpec<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Iterable<T>.tabulate(
    configure: TableSpec<T>.() -> Unit,
): List<String> = this.tabulateAsSequence(configure).toList()

fun <T> Iterator<T>.tabulate(
    configure: TableSpec<T>.() -> Unit,
): Iterator<String> = OnceOnlyIterableData(this).tabulate(configure)

fun <T> Sequence<T>.tabulatingIterator(
    configure: TableSpec<T>.() -> Unit,
): Iterator<String> = this.iterator().tabulate(configure)

fun <T> Sequence<T>.tabulate(
    configure: TableSpec<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Array<T>.tabulatingIterator(
    configure: TableSpec<T>.() -> Unit,
): Iterator<String> = MultiIterableData(this.asIterable()).tabulate(configure)

fun <T> Array<T>.tabulateAsSequence(
    configure: TableSpec<T>.() -> Unit,
): Sequence<String> = this.tabulatingIterator(configure).asSequence()

fun <T> Array<T>.tabulate(
    configure: TableSpec<T>.() -> Unit,
): List<String> = this.tabulateAsSequence(configure).toList()