package dev.coderoutine.tabulate

internal sealed interface Data<T> {
    fun measurementIterator(): Iterator<T>
    fun outputIterator(): Iterator<T>
}

internal class MultiIterableData<T> (
    private val iterable: Iterable<T>
) : Data<T> {
    override fun measurementIterator() = iterable.iterator()
    override fun outputIterator() = iterable.iterator()
}

internal class OnceOnlyIterableData<T>(
    private val iterator: Iterator<T>
) : Data<T> {
    private var cache: CachingIterator<T>? = null

    override fun measurementIterator(): Iterator<T> {
        return cache?.list?.iterator() ?: CachingIterator(iterator).also {
            cache = it
        }
    }

    override fun outputIterator(): Iterator<T> {
        return cache?.list?.iterator() ?: iterator
    }

    private class CachingIterator<T>(
        private val iterator: Iterator<T>
    ) : Iterator<T> by iterator {
        val list = mutableListOf<T>()

        override fun next(): T {
            val next = iterator.next()
            list.add(next)
            return next
        }
    }
}