/*
 * Decompiled with CFR 0.152.
 */
package dev.dhruv.javaannotate.core.method;

import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import dev.dhruv.javaannotate.core.method.MethodCreator;
import dev.dhruv.javaannotate.models.FieldModel;
import java.util.Collection;
import javax.lang.model.element.Modifier;

public class AllFieldConstructorCreator
extends MethodCreator {
    private Collection<FieldModel> fieldModels;

    public AllFieldConstructorCreator(Collection<FieldModel> fieldModels) {
        this.fieldModels = fieldModels;
    }

    @Override
    public MethodSpec create() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (FieldModel fieldModel : this.fieldModels) {
            if (fieldModel.isFinal()) continue;
            ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)fieldModel.getTypeName(), (String)fieldModel.getFieldName(), (Modifier[])new Modifier[0]).build();
            constructor.addParameter(parameterSpec);
            constructor.addStatement("this." + fieldModel.getFieldName() + "=" + fieldModel.getFieldName() + "\n", new Object[0]);
        }
        return constructor.build();
    }
}

