/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.fnjl.util.FNStringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class FNDokataUtil {
    private static final Map<String, String> DOKATA = new HashMap<String, String>();

    private static String getDokata(String string) {
        InputStream stream = FNDokataUtil.class.getResourceAsStream("/dokata/" + string);
        if (stream != null) {
            try {
                stream = FNDataUtil.unzipGz(stream);
                DOKATA.put(string, FNStringUtil.decodeBase64(new String(FNDataUtil.streamToByteArray(stream), StandardCharsets.UTF_8)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return DOKATA.get(string);
    }

    public static String getKusomamirede() {
        return FNDokataUtil.getDokata("kusomamire");
    }

    public static String getYattaze() {
        return FNDokataUtil.getDokata("yattaze");
    }

    public static String getYaritai() {
        return FNDokataUtil.getDokata("yaritai");
    }

    public static String getSenzuri() {
        return FNDokataUtil.getDokata("senzuri");
    }

    public static String getKusoKusoKuso() {
        return FNDokataUtil.getDokata("kusokusokuso");
    }

    public static String getKusomamire() {
        return FNDokataUtil.getDokata("kusomamirede");
    }

    public static String getKusozukiOyajiJisamaBoshu() {
        return FNDokataUtil.getDokata("kusozukioyajijisamaboshu");
    }

    public static String getKusomamirede2() {
        return FNDokataUtil.getDokata("kusomamirede2");
    }

    public static String getHayakuYariMakuriTaiyo() {
        return FNDokataUtil.getDokata("hayakuyarimakuritaiyo");
    }

    public static String getHayakuKusoMamireni() {
        return FNDokataUtil.getDokata("hayakukusomamireni");
    }

    public static String getKusomamire2() {
        return FNDokataUtil.getDokata("kusomamire2");
    }

    public static String getKusomamire3() {
        return FNDokataUtil.getDokata("kusomamire3");
    }

    public static String getKindanSyouJoga() {
        return FNDokataUtil.getDokata("kindansyoujoga");
    }

    public static String getKusoOyaji() {
        return FNDokataUtil.getDokata("kusooyaji");
    }

    public static String getYarouze() {
        return FNDokataUtil.getDokata("yarouze");
    }

    public static String getYagaiDe() {
        return FNDokataUtil.getDokata("yagaide");
    }

    public static String getKusomamire4() {
        return FNDokataUtil.getDokata("kusomamire4");
    }

    public static String getYaritexe() {
        return FNDokataUtil.getDokata("yaritexe");
    }

    public static String getKusomamirede3() {
        return FNDokataUtil.getDokata("kusomamirede3");
    }

    public static String getKusomamire5() {
        return FNDokataUtil.getDokata("kusomamire5");
    }

    public static String getKuso() {
        return FNDokataUtil.getDokata("kuso");
    }

    public static String getKusoDaisuki() {
        return FNDokataUtil.getDokata("kusodaisuki");
    }

    public static String getYamaNoNakaDe() {
        return FNDokataUtil.getDokata("yamanonakade");
    }

    public static String getYamaNoNakaDe2() {
        return FNDokataUtil.getDokata("yamanonakade2");
    }

    public static String getYamaNoNakaDe3() {
        return FNDokataUtil.getDokata("yamanonakade3");
    }

    public static String getSibatte() {
        return FNDokataUtil.getDokata("sibatte");
    }

    public static String getHonkide() {
        return FNDokataUtil.getDokata("honkide");
    }

    public static String getHentaiDaisuki() {
        return FNDokataUtil.getDokata("hentaidaisuki");
    }

    public static String getFuroShaNoOssan() {
        return FNDokataUtil.getDokata("furoshanoossan");
    }

    public static String getYagaiDe2() {
        return FNDokataUtil.getDokata("yagaide2");
    }

    public static String getMakkuro() {
        return FNDokataUtil.getDokata("makkuro");
    }

    public static String getYarimakuri() {
        return FNDokataUtil.getDokata("yarimakuri");
    }

    public static String getKushizashi() {
        return FNDokataUtil.getDokata("kushizashi");
    }

    public static String getRoshutsuShitaZe() {
        return FNDokataUtil.getDokata("roshutsushitaze");
    }

    public static String getYarouze2() {
        return FNDokataUtil.getDokata("yarouze2");
    }

    public static String getIssyoni() {
        return FNDokataUtil.getDokata("issyoni");
    }

    public static String getOkayamade() {
        return FNDokataUtil.getDokata("okayamade");
    }

    public static String getKurashikiMukaiyamaRoshutsuZuki() {
        return FNDokataUtil.getDokata("kurashikimukaiyamaroshutsuzuki");
    }

    public static enum Dokata {
        KUSOMAMIRE(FNDokataUtil::getKusomamire),
        YATTAZE(FNDokataUtil::getYattaze),
        YARITAI(FNDokataUtil::getYaritai),
        SENZURI(FNDokataUtil::getSenzuri),
        KUSOKUSOKUSO(FNDokataUtil::getKusoKusoKuso),
        KUSOMAMIREDE(FNDokataUtil::getKusomamirede),
        KUSOZUKIOYAJIJISAMABOSHU(FNDokataUtil::getKusozukiOyajiJisamaBoshu),
        KUSOMAMIREDE2(FNDokataUtil::getKusomamirede2),
        HAYAKUYARIMAKURITAIYO(FNDokataUtil::getHayakuYariMakuriTaiyo),
        HAYAKUKUSOMAMIRENI(FNDokataUtil::getHayakuKusoMamireni),
        KUSOMAMIRE2(FNDokataUtil::getKusomamire2),
        KUSOMAMIRE3(FNDokataUtil::getKusomamire3),
        KINDANSYOUJOGA(FNDokataUtil::getKindanSyouJoga),
        KUSOOYAJI(FNDokataUtil::getKusoOyaji),
        YAROUZE(FNDokataUtil::getYarouze),
        YAGAIDE(FNDokataUtil::getYagaiDe),
        KUSOMAMIRE4(FNDokataUtil::getKusomamire4),
        YARITEXE(FNDokataUtil::getYaritexe),
        KUSOMAMIREDE3(FNDokataUtil::getKusomamirede3),
        KUSOMAMIRE5(FNDokataUtil::getKusomamire5),
        KUSO(FNDokataUtil::getKuso),
        KUSODAISUKI(FNDokataUtil::getKusoDaisuki),
        YAMANONAKADE(FNDokataUtil::getYamaNoNakaDe),
        YAMANONAKADE2(FNDokataUtil::getYamaNoNakaDe2),
        YAMANONAKADE3(FNDokataUtil::getYamaNoNakaDe3),
        SIBATTE(FNDokataUtil::getSibatte),
        HONKIDE(FNDokataUtil::getHonkide),
        HENTAIDAISUKI(FNDokataUtil::getHentaiDaisuki),
        FUROSHANOOSSAN(FNDokataUtil::getFuroShaNoOssan),
        YAGAIDE2(FNDokataUtil::getYagaiDe2),
        MAKKURO(FNDokataUtil::getMakkuro),
        YARIMAKURI(FNDokataUtil::getYarimakuri),
        KUSHIZASHI(FNDokataUtil::getKushizashi),
        ROSHUTSUSHITAZE(FNDokataUtil::getRoshutsuShitaZe),
        YAROUZE2(FNDokataUtil::getYarouze2),
        ISSYONI(FNDokataUtil::getIssyoni),
        OKAYAMADE(FNDokataUtil::getOkayamade),
        KURASHIKIMUKAIYAMAROSHUTSUZUKI(FNDokataUtil::getKurashikiMukaiyamaRoshutsuZuki);

        private final Supplier<String> str;

        private Dokata(Supplier<String> st) {
            this.str = st;
        }

        public String getString() {
            return this.str.get();
        }
    }
}

