/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class FNImageUtil {
    public static BufferedImage clone(BufferedImage image) {
        BufferedImage out = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D graphics = out.createGraphics();
        graphics.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        return out;
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        return FNImageUtil.resize(image, width, height, 16);
    }

    public static BufferedImage resize(BufferedImage image, int width, int height, int hints) {
        BufferedImage out = new BufferedImage(width, height, image.getType());
        Graphics2D graphics = out.createGraphics();
        graphics.drawImage(image.getScaledInstance(width, height, hints), 0, 0, width, height, null);
        return out;
    }

    public static byte[] toByteArray(BufferedImage image, String formatName) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, formatName, baos);
        baos.flush();
        byte[] imgebyte = baos.toByteArray();
        baos.close();
        return imgebyte;
    }

    public static InputStream toInputStream(BufferedImage image, String formatName) throws IOException {
        return new ByteArrayInputStream(FNImageUtil.toByteArray(image, formatName));
    }

    public static void inputToOutputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }
}

