/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FNStringUtil {
    private static final String[] unit = new String[]{"K", "M", "G", "T", "P", "E", "Z", "Y"};

    public static String decodeUTFEscapeSequence(String unicode) {
        String[] codeStrs = unicode.split("\\\\u");
        int[] codePoints = new int[codeStrs.length - 1];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = Integer.parseInt(codeStrs[i + 1], 16);
        }
        return new String(codePoints, 0, codePoints.length);
    }

    public static String encodeUTFEscapeSequence(String original) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            sb.append(String.format("\\u%04X", Character.codePointAt(original, i)));
        }
        return sb.toString();
    }

    public static String decodeBase64(String base64) {
        return new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
    }

    public static String encodeBase64(String original) {
        return Base64.getEncoder().encodeToString(original.getBytes(StandardCharsets.UTF_8));
    }

    public static String getExtension(String name) {
        String[] sps = name.split("\\.");
        if (sps.length > 1) {
            return sps[sps.length - 1];
        }
        return null;
    }

    public static String removeExtension(String name) {
        String[] sps = name.split("\\.");
        if (sps.length > 1) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < sps.length - 1; ++i) {
                sb.append(sps[i]).append(".");
            }
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return name;
    }

    public static String getByteDisplay(long length) {
        return FNStringUtil.getByteDisplay(length, 1000L);
    }

    public static String getByteDisplay(long length, long kbCont) {
        int keta = (int)Math.floor(Math.log10(length));
        if (keta <= 2) {
            return String.format("%sByte", length);
        }
        int kets = keta - 2;
        float val = (float)((double)length / Math.pow(kbCont, 1 + (int)Math.floor((float)kets / 3.0f)));
        return String.format("%s%sB", Float.valueOf(val), unit[(int)Math.floor((float)kets / 3.0f)]);
    }

    public static String decodeHTMLSpecialCharacter(String text) {
        text = text.replace("\u200b", "");
        text = text.replace("\u3000", " ");
        text = text.replace("&lt;", "<");
        text = text.replace("&gt;", ">");
        text = text.replace("&amp;", "&");
        text = text.replace("&quot;", "\"");
        text = text.replace("&#39;", "'");
        text = text.replace("&nbsp;", " ");
        text = text.replace("&iexcl;", "\u00a1");
        text = text.replace("&cent;", "\u00a2");
        text = text.replace("&pound;", "\u00a3");
        text = text.replace("&curren;", "\u00a4");
        text = text.replace("&yen;", "\u00a5");
        text = text.replace("&euro;", "\u20ac");
        text = text.replace("&brvbar;", "\u00a6");
        text = text.replace("&sect;", "\u00a7");
        text = text.replace("&uml;", "\u00a8");
        text = text.replace("&copy;", "\u00a9");
        text = text.replace("&ordf;", "\u00aa");
        text = text.replace("&laquo;", "\u00ab");
        text = text.replace("&not;", "\u00ac");
        text = text.replace("&shy;", "");
        text = text.replace("&reg;", "\u00ae");
        text = text.replace("&macr;", "\u00af");
        text = text.replace("&deg;", "\u00b0");
        text = text.replace("&plusmn;", "\u00b1");
        text = text.replace("&sup2;", "\u00b2");
        text = text.replace("&sup3;", "\u00b3");
        text = text.replace("&acute;", "\u00b4");
        text = text.replace("&micro;", "\u00b5");
        text = text.replace("&para;", "\u00b6");
        text = text.replace("&middot;", "\u00b7");
        text = text.replace("&cedil;", "\u00b8");
        text = text.replace("&sup1;", "\u00b9");
        text = text.replace("&ordm;", "\u00ba");
        text = text.replace("&raquo;", "\u00bb");
        text = text.replace("&frac14;", "\u00bc");
        text = text.replace("&frac12;", "\u00bd");
        text = text.replace("&frac34;", "\u00be");
        text = text.replace("&iquest;", "\u00bf");
        text = text.replace("&circ;", "\u02c6");
        text = text.replace("&tilde;", "\u02dc");
        return text;
    }

    public static String getPercentage(int complete, int total) {
        return FNStringUtil.getPercentage((double)complete / (double)total);
    }

    public static String getPercentage(long complete, long total) {
        return FNStringUtil.getPercentage((double)complete / (double)total);
    }

    public static String getPercentage(double par) {
        return (int)(par * 100.0) + "%";
    }

    public static String getPercentage(float par) {
        return (int)(par * 100.0f) + "%";
    }

    public static UUID fromNoHyphenStringToUUID(String uuidStr) {
        return UUID.fromString(uuidStr.replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"));
    }

    @Nullable
    public static UUID getUUIDFromStringNonThrow(@NotNull String text) {
        try {
            return UUID.fromString(text);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTimeProgress(long compTime, long totalTime) {
        return FNStringUtil.getTimeFormat(compTime, totalTime >= 3600000L) + "/" + FNStringUtil.getTimeFormat(totalTime);
    }

    public static String getTimeFormat(long time) {
        return FNStringUtil.getTimeFormat(time, false);
    }

    public static String getTimeFormat(long time, boolean hour) {
        long hourTime = time / 3600000L;
        long minTime = (time - hourTime * 3600000L) / 60000L;
        long secTime = (time - hourTime * 3600000L - minTime * 60000L) / 1000L;
        if (hourTime > 0L || hour) {
            return String.format("%02d:%02d:%02d", hourTime, minTime, secTime);
        }
        return String.format("%02d:%02d", minTime, secTime);
    }
}

