/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import dev.felnull.fnjl.FelNullJavaLibrary;
import dev.felnull.fnjl.io.PostRequest;
import dev.felnull.fnjl.io.PostResponse;
import dev.felnull.fnjl.util.FNDataUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FNURLUtil {
    @Nullable
    public static URL newURL(@Nullable String url) {
        try {
            return new URL(Objects.requireNonNull(url));
        }
        catch (NullPointerException | MalformedURLException e) {
            return null;
        }
    }

    @NotNull
    public static String getUserAgent() {
        String jv = System.getProperty("java.version");
        String jvn = System.getProperty("java.vm.name");
        String jvv = System.getProperty("java.vm.version");
        return String.format("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/102.0.0.0 Safari/537.36 %s %s", "Java/" + jv + " (" + jvn + "; " + jvv + ")", "FelNullJavaLibrary/" + FelNullJavaLibrary.getVersion());
    }

    @NotNull
    public static HttpURLConnection getConnection(@NotNull URL url, @NotNull Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("user-agent", FNURLUtil.getUserAgent());
        headers.forEach(connection::addRequestProperty);
        return connection;
    }

    @NotNull
    public static HttpURLConnection getConnection(@NotNull URL url) throws IOException {
        return FNURLUtil.getConnection(url, new HashMap<String, String>());
    }

    @NotNull
    public static InputStream getStream(@NotNull URL url) throws IOException {
        return FNURLUtil.getConnection(url).getInputStream();
    }

    @NotNull
    public static String getResponse(@NotNull URL url) throws IOException {
        return FNDataUtil.readAllString(FNURLUtil.getStream(url));
    }

    public static CompletableFuture<Void> getStreamAsync(URL url, Consumer<InputStream> streamConsumer) {
        return CompletableFuture.runAsync(() -> {
            InputStream stream = null;
            try {
                stream = FNURLUtil.getStream(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            streamConsumer.accept(stream);
        });
    }

    public static CompletableFuture<Void> getResponseAsync(URL url, Consumer<String> stringConsumer) {
        return CompletableFuture.runAsync(() -> {
            String str = null;
            try {
                str = FNURLUtil.getResponse(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            stringConsumer.accept(str);
        });
    }

    public static CompletableFuture<Void> getResponseByPOSTAsync(URL url, String body, String language, String contentType, Consumer<PostResponse> responseConsumer) {
        return CompletableFuture.runAsync(() -> {
            PostResponse ret = null;
            try {
                ret = FNURLUtil.getResponseByPOST(url, body, language, contentType);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            responseConsumer.accept(ret);
        });
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, @NotNull String body, @NotNull String language, @NotNull String contentType) throws IOException {
        return FNURLUtil.getResponseByPOST(url, PostRequest.newRequest(body, PostRequest.HeaderBuilder.newBuilder().setLanguage(language).setContentType(contentType).build()));
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, byte[] body, @NotNull Map<String, String> headers) throws IOException {
        return FNURLUtil.getResponseByPOST(url, PostRequest.newRequest(body, headers));
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, @NotNull PostRequest request) throws IOException {
        byte[] res;
        HttpURLConnection con = FNURLUtil.getConnection(url, request.getHeaders());
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        try (OutputStream outst = con.getOutputStream();){
            request.getBody().accept(outst);
            outst.flush();
        }
        con.connect();
        int sts = con.getResponseCode();
        String encoding = con.getContentEncoding();
        try (InputStream in = con.getInputStream();){
            res = FNDataUtil.streamToByteArray(in);
        }
        return new PostResponse(res, sts, encoding);
    }
}

