/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import dev.felnull.fnjl.io.ProgressWriter;
import dev.felnull.fnjl.io.resource.ResourceEntry;
import dev.felnull.fnjl.io.resource.ResourceEntryImpl;
import dev.felnull.fnjl.io.watcher.FileSystemWatcher;
import dev.felnull.fnjl.util.FNURLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FNDataUtil {
    public static String readAllString(InputStream stream) throws IOException {
        return FNDataUtil.readAllString(stream, StandardCharsets.UTF_8);
    }

    public static String readAllString(InputStream stream, Charset cs) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream, cs);){
            String string = FNDataUtil.readAllString(reader);
            return string;
        }
    }

    public static String readAllString(Reader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean flg = false;
        try (BufferedReader breader = new BufferedReader(reader);){
            String next;
            while ((next = breader.readLine()) != null) {
                if (flg) {
                    sb.append('\n');
                }
                sb.append(next);
                flg = true;
            }
        }
        return sb.toString();
    }

    public static byte[] bufStreamToByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FNDataUtil.bufInputToOutput(stream, bout);
        return bout.toByteArray();
    }

    public static byte[] bufStreamToByteArray(InputStream stream, int size) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FNDataUtil.bufInputToOutput(stream, bout, size);
        return bout.toByteArray();
    }

    public static byte[] streamToByteArray(InputStream stream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FNDataUtil.inputToOutput(stream, bout);
        return bout.toByteArray();
    }

    public static byte[] streamToByteArray(InputStream stream, int size) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FNDataUtil.inputToOutput(stream, bout, size);
        return bout.toByteArray();
    }

    /*
     * Exception decompiling
     */
    @NotNull
    public static InputStream zipGz(@NotNull InputStream data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static InputStream unzipGz(InputStream data) throws IOException {
        return new GZIPInputStream(data);
    }

    public static byte[] createMD5Hash(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return md5.digest(data);
    }

    public static void fileWriteToProgress(InputStream stream, long length, File file, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        if (length <= 0L) {
            throw new IOException("Invalid length");
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bout = new BufferedOutputStream(fos, 1024);
        ProgressWriter writer = new ProgressWriter(stream, length, data -> {
            try {
                bout.write(data.getBytes(), 0, Math.toIntExact(data.getReadSize()));
            }
            catch (IOException e) {
                return e;
            }
            return null;
        }, progress);
        writer.start();
        bout.close();
        stream.close();
    }

    public static void fileDownloadToProgress(URL url, File file, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        HttpURLConnection connection = FNURLUtil.getConnection(url);
        long length = connection.getContentLengthLong();
        FNDataUtil.fileWriteToProgress(connection.getInputStream(), length, file, progress);
    }

    public static void fileCopyToProgress(File copyFile, File file, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        FNDataUtil.fileWriteToProgress(Files.newInputStream(copyFile.toPath(), new OpenOption[0]), copyFile.length(), file, progress);
    }

    public static byte[] loadToProgress(InputStream stream, long length, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        if (length <= 0L) {
            throw new IOException("Invalid length");
        }
        byte[] bytes = new byte[Math.toIntExact(length)];
        AtomicInteger cont = new AtomicInteger();
        ProgressWriter writer = new ProgressWriter(stream, length, data -> {
            System.arraycopy(data.getBytes(), 0, bytes, cont.get(), Math.toIntExact(data.getReadSize()));
            cont.getAndAdd(Math.toIntExact(data.getReadSize()));
            return null;
        }, progress);
        writer.start();
        stream.close();
        return bytes;
    }

    public static byte[] urlLoadToProgress(URL url, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        HttpURLConnection connection = FNURLUtil.getConnection(url);
        long length = connection.getContentLengthLong();
        return FNDataUtil.loadToProgress(connection.getInputStream(), length, progress);
    }

    public static byte[] fileLoadToProgress(File file, Consumer<ProgressWriter.WriteProgressListener> progress) throws IOException {
        return FNDataUtil.loadToProgress(Files.newInputStream(file.toPath(), new OpenOption[0]), file.length(), progress);
    }

    @Nullable
    public static InputStream resourceExtractor(@NotNull Class<?> clazz, @NotNull String path) {
        InputStream stream;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((stream = clazz.getResourceAsStream("/" + path)) == null) {
            stream = ClassLoader.getSystemResourceAsStream(path);
        }
        return stream;
    }

    /*
     * Loose catch block
     */
    @Nullable
    public static InputStream resourceBufferedExtractor(@NotNull Class<?> clazz, @NotNull String path) throws IOException {
        block28: {
            Throwable throwable = null;
            try (InputStream stream = FNDataUtil.resourceExtractor(clazz, path);){
                if (stream != null) {
                    try (BufferedInputStream bufStream = new BufferedInputStream(stream);){
                        BufferedInputStream bufferedInputStream = bufStream;
                        return bufferedInputStream;
                    }
                }
                break block28;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                    }
                }
            }
        }
        return null;
    }

    @Deprecated
    public static void watchFile(Path path, Consumer<WatchEvent<?>> listener, WatchEvent.Kind<?> ... events) throws IOException {
        FNDataUtil.watchFile(path, (WatchEvent<Path> watchEvent, Path path1) -> listener.accept(watchEvent), events);
    }

    @NotNull
    public static FileSystemWatcher watchFile(@NotNull Path path, @NotNull FileSystemWatcher.WatchEventListener listener, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newFileWatcher(path, listener, events);
    }

    @NotNull
    public static FileSystemWatcher watchFile(@NotNull Path path, @NotNull FileSystemWatcher.WatchEventListener listener, @NotNull ThreadFactory threadFactory, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newFileWatcher(path, listener, threadFactory, events);
    }

    @NotNull
    public static FileSystemWatcher watchDirectory(@NotNull Path path, @NotNull FileSystemWatcher.WatchEventListener listener, @NotNull ThreadFactory threadFactory, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newDirectoryWatcher(path, listener, threadFactory, events);
    }

    @NotNull
    public static FileSystemWatcher watchDirectory(@NotNull Path path, @NotNull FileSystemWatcher.WatchEventListener listener, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newDirectoryWatcher(path, listener, events);
    }

    @NotNull
    public static FileSystemWatcher watchDirectoryTree(@NotNull Path rootPath, @NotNull FileSystemWatcher.WatchEventListener listener, @NotNull ThreadFactory threadFactory, boolean flowSymbolic, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newDirectoryTreeWatcher(rootPath, listener, threadFactory, flowSymbolic, events);
    }

    @NotNull
    public static FileSystemWatcher watchDirectoryTree(@NotNull Path rootPath, @NotNull FileSystemWatcher.WatchEventListener listener, boolean flowSymbolic, WatchEvent.Kind<?> ... events) throws IOException {
        return FileSystemWatcher.newDirectoryTreeWatcher(rootPath, listener, flowSymbolic, events);
    }

    public static void inputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        FNDataUtil.inputToOutput(inputStream, outputStream, 1024);
    }

    public static void inputToOutput(InputStream inputStream, OutputStream outputStream, int size) throws IOException {
        try (InputStream in = inputStream;
             OutputStream out = outputStream;){
            int len;
            byte[] data = new byte[size];
            while ((len = in.read(data)) != -1) {
                out.write(data, 0, len);
            }
        }
    }

    public static void bufInputToOutput(InputStream inputStream, OutputStream outputStream, int size) throws IOException {
        FNDataUtil.inputToOutput(new BufferedInputStream(inputStream), new BufferedOutputStream(outputStream), size);
    }

    public static void bufInputToOutput(InputStream inputStream, OutputStream outputStream) throws IOException {
        FNDataUtil.inputToOutput(new BufferedInputStream(inputStream), new BufferedOutputStream(outputStream));
    }

    public static void readZip(InputStream zipStream, BiConsumer<ZipEntry, ZipInputStream> zips) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(zipStream);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                zips.accept(ze, zis);
            }
        }
    }

    public static void readZipStreamed(InputStream zipStream, BiConsumer<ZipEntry, InputStream> zips) throws IOException {
        FNDataUtil.readZip(zipStream, (e, i) -> {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                int count;
                byte[] data = new byte[1024];
                while ((count = i.read(data)) != -1) {
                    baos.write(data, 0, count);
                }
                zips.accept((ZipEntry)e, new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException ex) {
                zips.accept((ZipEntry)e, (InputStream)null);
            }
        });
    }

    @NotNull
    public static <T, M> Function<T, M> memoize(final @NotNull Function<T, M> function) {
        return new Function<T, M>(){
            private final Map<T, M> cache = new HashMap();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public M apply(T t) {
                Map map = this.cache;
                synchronized (map) {
                    return this.cache.computeIfAbsent(t, function);
                }
            }
        };
    }

    @NotNull
    public static <T> Supplier<T> memoize(final @NotNull Supplier<T> supplier) {
        return new Supplier<T>(){
            private final AtomicReference<T> cache = new AtomicReference();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                AtomicReference atomicReference = this.cache;
                synchronized (atomicReference) {
                    Object ret = this.cache.get();
                    if (ret == null) {
                        ret = supplier.get();
                        this.cache.set(ret);
                    }
                    return ret;
                }
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<ResourceEntry> resourceExtractEntry(@NotNull Class<?> clazz, @NotNull String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URL url = clazz.getResource(path);
        Path tp = Paths.get(path, new String[0]);
        if (url == null) throw new RuntimeException("not exists file");
        try {
            URI uri = url.toURI();
            String scheme = uri.getScheme();
            if (!"jar".equals(uri.getScheme())) return FNDataUtil.getResourceEntry(Paths.get(uri), tp, scheme, clazz);
            try (FileSystem fs = FileSystems.newFileSystem(uri, new HashMap());){
                List<ResourceEntry> list = FNDataUtil.getResourceEntry(fs.getPath(path, new String[0]), tp, scheme, clazz);
                return list;
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ResourceEntry> getResourceEntry(Path path, Path targetPath, String scheme, Class<?> clazz) throws IOException {
        ArrayList entries = new ArrayList();
        try (Stream<Path> wlk = Files.walk(path, 1, new FileVisitOption[0]).filter(n -> !n.equals(path));){
            wlk.forEach(p -> {
                String name = p.getName(p.getNameCount() - 1).toString();
                ResourceEntryImpl re = new ResourceEntryImpl(name, Files.isDirectory(p, new LinkOption[0]), scheme, targetPath.resolve(name).toString(), clazz);
                entries.add(re);
            });
        }
        return Collections.unmodifiableList(entries);
    }

    public static void wishMkdir(@NotNull File file) {
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Failed to create fold: " + file.getAbsolutePath());
        }
    }

    public static boolean wishMkdir(@NotNull File file, Consumer<File> failedConsumer) {
        if (!file.exists() && !file.mkdirs()) {
            failedConsumer.accept(file);
            return false;
        }
        return true;
    }
}

