/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.os;

import java.util.Locale;

public class OSs {
    public static String getOSName() {
        return System.getProperty("os.name");
    }

    public static String getOSArch() {
        return System.getProperty("os.arch");
    }

    public static Type getOS() {
        String osName = OSs.getOSName().toLowerCase(Locale.ROOT);
        for (Type value : Type.values()) {
            if (!osName.contains(value.getName())) continue;
            return value;
        }
        return Type.OTHER;
    }

    public static boolean isWindows() {
        return OSs.getOS() == Type.WINDOWS;
    }

    public static boolean isLinux() {
        return OSs.getOS() == Type.LINUX;
    }

    public static boolean isMAC() {
        return OSs.getOS() == Type.MAC;
    }

    public static boolean isX64() {
        return "amd64".equalsIgnoreCase(OSs.getOSArch()) || "x86_64".equalsIgnoreCase(OSs.getOSArch());
    }

    public static boolean isX86() {
        return "x86".equalsIgnoreCase(OSs.getOSArch()) || "i386".equalsIgnoreCase(OSs.getOSArch());
    }

    public static boolean isArm64() {
        return "aarch64".equalsIgnoreCase(OSs.getOSArch());
    }

    public static boolean isArm32() {
        return "arm".equalsIgnoreCase(OSs.getOSArch());
    }

    public static String getArch() {
        if (OSs.isX64()) {
            return "x64";
        }
        if (OSs.isX86()) {
            return "x86";
        }
        if (OSs.isArm64()) {
            return "arm64";
        }
        if (OSs.isArm32()) {
            return "arm32";
        }
        return "no-support";
    }

    public static enum Type {
        WINDOWS("windows", "dll"),
        LINUX("linux", "so"),
        MAC("mac", "jnilib"),
        OTHER(null, null);

        private final String name;
        private final String libName;

        private Type(String name, String libName) {
            this.name = name;
            this.libName = libName;
        }

        public String getName() {
            return this.name;
        }

        public String getLibName() {
            return this.libName;
        }
    }
}

