/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.util;

import dev.felnull.fnjl.FelNullJavaLibrary;
import dev.felnull.fnjl.io.PostRequest;
import dev.felnull.fnjl.io.PostResponse;
import dev.felnull.fnjl.util.FNDataUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FNURLUtil {
    @Nullable
    public static URL newURL(@Nullable String url) {
        try {
            return new URL(Objects.requireNonNull(url));
        }
        catch (NullPointerException | MalformedURLException e) {
            return null;
        }
    }

    @NotNull
    public static String getUserAgent() {
        String jv = System.getProperty("java.specification.version");
        return String.format("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.0.0 Safari/537.36 %s %s", "Java/" + jv, "FelNullJavaLibrary/" + FelNullJavaLibrary.getVersion());
    }

    @NotNull
    public static HttpURLConnection getConnection(@NotNull URL url, @NotNull Map<String, String> headers) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.addRequestProperty("user-agent", FNURLUtil.getUserAgent());
        headers.forEach(connection::addRequestProperty);
        return connection;
    }

    @NotNull
    public static HttpURLConnection getConnection(@NotNull URL url) throws IOException {
        return FNURLUtil.getConnection(url, new HashMap<String, String>());
    }

    @NotNull
    public static InputStream getStream(@NotNull URL url) throws IOException {
        return FNURLUtil.getConnection(url).getInputStream();
    }

    @NotNull
    public static String getResponse(@NotNull URL url) throws IOException {
        return FNDataUtil.readAllString(FNURLUtil.getStream(url));
    }

    @Deprecated
    public static CompletableFuture<Void> getStreamAsync(URL url, Consumer<InputStream> streamConsumer) {
        return FNURLUtil.getStreamAsync(url).thenAccept((Consumer)streamConsumer);
    }

    @NotNull
    public static CompletableFuture<InputStream> getStreamAsync(@NotNull URL url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return FNURLUtil.getStream(url);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    @Deprecated
    public static CompletableFuture<Void> getResponseAsync(URL url, Consumer<String> stringConsumer) {
        return FNURLUtil.getResponseAsync(url).thenAccept((Consumer)stringConsumer);
    }

    @NotNull
    public static CompletableFuture<String> getResponseAsync(@NotNull URL url) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return FNURLUtil.getResponse(url);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    @Deprecated
    public static CompletableFuture<Void> getResponseByPOSTAsync(URL url, String body, String language, String contentType, Consumer<PostResponse> responseConsumer) {
        return FNURLUtil.getResponseByPOSTAsync(url, body, language, contentType).thenAccept((Consumer)responseConsumer);
    }

    @NotNull
    public static CompletableFuture<PostResponse> getResponseByPOSTAsync(@NotNull URL url, @NotNull String body, @NotNull String language, @NotNull String contentType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return FNURLUtil.getResponseByPOST(url, body, language, contentType);
            }
            catch (IOException e) {
                return null;
            }
        });
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, @NotNull String body, @NotNull String language, @NotNull String contentType) throws IOException {
        return FNURLUtil.getResponseByPOST(url, PostRequest.newRequest(body, PostRequest.HeaderBuilder.newBuilder().setLanguage(language).setContentType(contentType).build()));
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, byte[] body, @NotNull Map<String, String> headers) throws IOException {
        return FNURLUtil.getResponseByPOST(url, PostRequest.newRequest(body, headers));
    }

    @NotNull
    public static PostResponse getResponseByPOST(@NotNull URL url, @NotNull PostRequest request) throws IOException {
        byte[] res;
        HttpURLConnection con = FNURLUtil.getConnection(url, request.getHeaders());
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        try (OutputStream outst = con.getOutputStream();){
            request.getBody().accept(outst);
            outst.flush();
        }
        con.connect();
        int sts = con.getResponseCode();
        String encoding = con.getContentEncoding();
        try (InputStream in = con.getInputStream();){
            res = FNDataUtil.readAllBytesBuff(in);
        }
        return new PostResponse(res, sts, encoding);
    }
}

