/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.io.resource;

import dev.felnull.fnjl.io.resource.ResourceEntry;
import dev.felnull.fnjl.util.FNDataUtil;
import java.io.InputStream;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ResourceEntryImpl
implements ResourceEntry {
    private final String name;
    private final boolean directory;
    private final String scheme;
    private final String path;
    private final Class<?> clazz;

    public ResourceEntryImpl(String name, boolean directory, String scheme, String path, Class<?> clazz) {
        this.name = name;
        this.directory = directory;
        this.scheme = scheme;
        this.path = path;
        this.clazz = clazz;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public boolean isDirectory() {
        return this.directory;
    }

    @Override
    public InputStream openInputStream() {
        if (this.isDirectory()) {
            throw new RuntimeException("directory");
        }
        return FNDataUtil.resourceExtractor(this.clazz, this.path);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceEntryImpl that = (ResourceEntryImpl)o;
        return this.directory == that.directory && Objects.equals(this.name, that.name) && Objects.equals(this.scheme, that.scheme) && Objects.equals(this.path, that.path) && Objects.equals(this.clazz, that.clazz);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.directory, this.scheme, this.path, this.clazz);
    }
}

