/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.math;

import dev.felnull.fnjl.math.FNVec3f;
import dev.felnull.fnjl.math.FNVec3i;
import dev.felnull.fnjl.math.FNVec4d;
import dev.felnull.fnjl.tuple.FNQuadruple;
import dev.felnull.fnjl.util.FNMath;
import java.util.Objects;

public class FNVec3d {
    private double x;
    private double y;
    private double z;

    public FNVec3d() {
    }

    public FNVec3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public FNVec3d copy() {
        return new FNVec3d(this.x, this.y, this.z);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double distance(FNVec3d vec) {
        return Math.sqrt(Math.pow(this.x - vec.getX(), 2.0) + Math.pow(this.y - vec.getY(), 2.0) + Math.pow(this.z - vec.getZ(), 2.0));
    }

    public FNVec3d add(FNVec3d vec) {
        this.x += vec.getX();
        this.y += vec.getY();
        this.z += vec.getZ();
        return this;
    }

    public FNVec3d sub(FNVec3d vec) {
        this.x -= vec.getX();
        this.y -= vec.getY();
        this.z -= vec.getZ();
        return this;
    }

    public FNVec3d radians() {
        this.x = Math.toRadians(this.x);
        this.y = Math.toRadians(this.y);
        this.z = Math.toRadians(this.z);
        return this;
    }

    public FNVec3d degrees() {
        this.x = Math.toDegrees(this.x);
        this.y = Math.toDegrees(this.y);
        this.z = Math.toDegrees(this.z);
        return this;
    }

    public FNVec3d normalized() {
        this.normalize();
        return this;
    }

    public boolean normalize() {
        double f = this.x * this.x + this.y * this.y + this.z * this.z;
        if (f < 1.0E-5) {
            return false;
        }
        double g = FNMath.fastInvSqrt(f);
        this.x *= g;
        this.y *= g;
        this.z *= g;
        return true;
    }

    public String toString() {
        return "FNVec3d{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FNVec3d fnVec3d = (FNVec3d)o;
        return Double.compare(fnVec3d.x, this.x) == 0 && Double.compare(fnVec3d.y, this.y) == 0 && Double.compare(fnVec3d.z, this.z) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public FNVec3f convertFloat() {
        return new FNVec3f((float)this.x, (float)this.y, (float)this.z);
    }

    public FNVec3i convertInt() {
        return new FNVec3i((int)this.x, (int)this.y, (int)this.z);
    }

    public FNVec4d toQuaternion() {
        FNQuadruple<Double, Double, Double, Double> q = FNMath.toQuaternion(this.x, this.y, this.z);
        return new FNVec4d(q.getLeft(), q.getLeftCenter(), q.getRightCenter(), q.getRight());
    }
}

