/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.fnjl.io.watcher;

import dev.felnull.fnjl.io.watcher.FileSystemWatcher;
import dev.felnull.fnjl.io.watcher.FileSystemWatcherImpl;
import dev.felnull.fnjl.util.FNArrayUtil;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DirectoryTreeWatcherImpl
extends FileSystemWatcherImpl {
    private final List<Path> watchingPaths = new ArrayList<Path>();
    private final Path rootPath;
    private final boolean flowSymbolic;
    private final boolean create;
    private final WatchEvent.Kind<?>[] events;

    protected DirectoryTreeWatcherImpl(Path rootPath, FileSystemWatcher.WatchEventListener watchEventListener, ThreadFactory threadFactory, boolean flowSymbolic, WatchEvent.Kind<?> ... events) throws IOException {
        super(watchEventListener, threadFactory);
        this.rootPath = rootPath;
        if (!FNArrayUtil.contains(events, StandardWatchEventKinds.ENTRY_CREATE)) {
            events = FNArrayUtil.add(events, StandardWatchEventKinds.ENTRY_CREATE);
            this.create = false;
        } else {
            this.create = true;
        }
        this.registerFiles(rootPath, flowSymbolic, events);
        this.flowSymbolic = flowSymbolic;
        this.events = events;
    }

    @Override
    protected void destroy() {
        super.destroy();
        this.watchingPaths.clear();
    }

    protected DirectoryTreeWatcherImpl(Path rootPath, FileSystemWatcher.WatchEventListener watchEventListener, boolean flowSymbolic, WatchEvent.Kind<?> ... events) throws IOException {
        super(watchEventListener, rootPath + "-directory-tree-watcher");
        this.rootPath = rootPath;
        if (!FNArrayUtil.contains(events, StandardWatchEventKinds.ENTRY_CREATE)) {
            events = FNArrayUtil.add(events, StandardWatchEventKinds.ENTRY_CREATE);
            this.create = false;
        } else {
            this.create = true;
        }
        this.registerFiles(rootPath, flowSymbolic, events);
        this.flowSymbolic = flowSymbolic;
        this.events = events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEvent(WatchKey key, WatchEvent<Path> watchEvent, int count) {
        if (watchEvent.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
            List<Path> list = this.watchingPaths;
            synchronized (list) {
                Path ap = this.getPath(key, watchEvent);
                if (!this.watchingPaths.contains(ap)) {
                    LinkOption[] linkOptionArray;
                    if (this.flowSymbolic) {
                        linkOptionArray = new LinkOption[]{};
                    } else {
                        LinkOption[] linkOptionArray2 = new LinkOption[1];
                        linkOptionArray = linkOptionArray2;
                        linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
                    }
                    if (Files.isDirectory(ap, linkOptionArray)) {
                        this.watchingPaths.add(ap);
                        try {
                            this.watchKeyPath.put(ap.register(this.watchService, this.events), ap);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (!this.create) {
                return;
            }
        }
        super.onEvent(key, watchEvent, count);
    }

    private void registerFiles(Path path, boolean flowSymbolic, WatchEvent.Kind<?> ... events) throws IOException {
        FileVisitOption[] fileVisitOptionArray;
        if (flowSymbolic) {
            FileVisitOption[] fileVisitOptionArray2 = new FileVisitOption[1];
            fileVisitOptionArray = fileVisitOptionArray2;
            fileVisitOptionArray2[0] = FileVisitOption.FOLLOW_LINKS;
        } else {
            fileVisitOptionArray = new FileVisitOption[]{};
        }
        try (Stream<Path> stream = Files.walk(path, fileVisitOptionArray);){
            stream.forEach(p -> {
                LinkOption[] linkOptionArray;
                if (flowSymbolic) {
                    linkOptionArray = new LinkOption[]{};
                } else {
                    LinkOption[] linkOptionArray2 = new LinkOption[1];
                    linkOptionArray = linkOptionArray2;
                    linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
                }
                if (Files.isDirectory(p, linkOptionArray)) {
                    Path pa = p.toAbsolutePath();
                    this.watchingPaths.add(pa);
                    try {
                        this.watchKeyPath.put(pa.register(this.watchService, events), pa);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }
}

