/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users.internal.routes;

import dev.galasa.framework.api.beans.generated.UserData;
import dev.galasa.framework.api.common.BaseRoute;
import dev.galasa.framework.api.common.Environment;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.JwtWrapper;
import dev.galasa.framework.api.common.QueryParameters;
import dev.galasa.framework.api.common.ResponseBuilder;
import dev.galasa.framework.api.common.ServletError;
import dev.galasa.framework.api.common.ServletErrorMessage;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.IFramework;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UsersRoute
extends BaseRoute {
    private static final String path = "\\/?";
    public static final String QUERY_PARAMETER_LOGIN_ID_VALUE_MYSELF = "me";
    private IFramework framework;
    private Environment env;

    public UsersRoute(ResponseBuilder responseBuilder, IFramework framework, Environment env) {
        super(responseBuilder, path);
        this.framework = framework;
        this.env = env;
    }

    public HttpServletResponse handleGetRequest(String pathInfo, QueryParameters queryParams, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, FrameworkException {
        this.logger.info((Object)"UserRoute: handleGetRequest() entered.");
        this.validateQueryParam(queryParams, request.getServletPath());
        List<UserData> usersList = this.getUsersList(request);
        String payloadContent = gson.toJson(usersList);
        return this.getResponseBuilder().buildResponse(request, response, "application/json", payloadContent, 200);
    }

    private void validateQueryParam(QueryParameters queryParams, String servletPath) throws InternalServletException {
        String loginId = queryParams.getSingleString("loginId", null);
        if (loginId == null) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5082_NO_LOGINID_PARAM_PROVIDED, new String[]{servletPath});
            throw new InternalServletException(error, 400);
        }
        if (!loginId.trim().equalsIgnoreCase(QUERY_PARAMETER_LOGIN_ID_VALUE_MYSELF)) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5081_INVALID_QUERY_PARAM_VALUE, new String[]{servletPath});
            throw new InternalServletException(error, 400);
        }
    }

    private List<UserData> getUsersList(HttpServletRequest request) throws InternalServletException {
        UserData userData = new UserData();
        JwtWrapper jwtWrapper = new JwtWrapper(request, this.env);
        String extractedUsernameFromToken = jwtWrapper.getUsername();
        userData.setLoginId(extractedUsernameFromToken);
        ArrayList<UserData> usersList = new ArrayList<UserData>();
        usersList.add(userData);
        return usersList;
    }
}

