/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users;

import dev.galasa.framework.api.common.BaseServlet;
import dev.galasa.framework.api.common.Environment;
import dev.galasa.framework.api.common.IRoute;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.SystemEnvironment;
import dev.galasa.framework.api.users.internal.routes.UserRoute;
import dev.galasa.framework.api.users.internal.routes.UsersRoute;
import dev.galasa.framework.auth.spi.AuthServiceFactory;
import dev.galasa.framework.auth.spi.IAuthService;
import dev.galasa.framework.auth.spi.IAuthServiceFactory;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.rbac.RBACException;
import dev.galasa.framework.spi.rbac.RBACService;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(service={Servlet.class}, scope=ServiceScope.PROTOTYPE, property={"osgi.http.whiteboard.servlet.pattern=/users/*"}, name="Galasa Users microservice")
public class UsersServlet
extends BaseServlet {
    @Reference
    protected IFramework framework;
    public static final String QUERY_PARAM_LOGIN_ID = "loginId";
    public static final String QUERY_PARAMETER_LOGIN_ID_VALUE_MYSELF = "me";
    private static final long serialVersionUID = 1L;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private IAuthServiceFactory factory;

    public UsersServlet() {
        this((Environment)new SystemEnvironment());
    }

    public UsersServlet(Environment env) {
        super(env);
    }

    public void init() throws ServletException {
        RBACService rbacService;
        IAuthService authService;
        this.logger.info((Object)"Galasa Users API initialising");
        if (this.factory == null) {
            this.factory = new AuthServiceFactory(this.framework, this.env);
        }
        try {
            authService = this.factory.getAuthService();
            rbacService = this.framework.getRBACService();
        }
        catch (InternalServletException | RBACException ex) {
            throw new ServletException(ex);
        }
        this.addRoute((IRoute)new UsersRoute(this.getResponseBuilder(), this.env, authService, rbacService));
        this.addRoute((IRoute)new UserRoute(this.getResponseBuilder(), this.env, authService, rbacService));
        this.logger.info((Object)"Galasa Users API initialised");
    }

    protected void setAuthServiceFactory(IAuthServiceFactory factory) {
        this.factory = factory;
    }
}

