/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users.internal.routes;

import dev.galasa.framework.api.beans.generated.FrontEndClient;
import dev.galasa.framework.api.beans.generated.RBACRole;
import dev.galasa.framework.api.beans.generated.UserData;
import dev.galasa.framework.api.beans.generated.UserSynthetics;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.ServletError;
import dev.galasa.framework.api.common.ServletErrorMessage;
import dev.galasa.framework.api.rbac.RoleTransform;
import dev.galasa.framework.spi.auth.IFrontEndClient;
import dev.galasa.framework.spi.auth.IUser;
import dev.galasa.framework.spi.rbac.RBACException;
import dev.galasa.framework.spi.rbac.RBACService;
import dev.galasa.framework.spi.rbac.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BeanTransformer {
    private String baseUrl;
    private RBACService rbacService;

    public BeanTransformer(String baseUrl, RBACService rbacService) {
        this.baseUrl = baseUrl;
        this.rbacService = rbacService;
    }

    public List<UserData> convertAllUsersToUserBean(Collection<IUser> users) throws InternalServletException {
        ArrayList<UserData> convertedUserList = new ArrayList<UserData>();
        if (users != null) {
            for (IUser userIn : users) {
                UserData userOut = this.convertUserToUserBean(userIn);
                convertedUserList.add(userOut);
            }
        }
        return convertedUserList;
    }

    public UserData convertUserToUserBean(IUser userIn) throws InternalServletException {
        UserData userOut = new UserData();
        userOut.setLoginId(userIn.getLoginId());
        userOut.setid(userIn.getUserNumber());
        userOut.seturl(this.calculateUrl(userIn.getUserNumber()));
        ArrayList<FrontEndClient> clientsOutList = new ArrayList<FrontEndClient>();
        Collection clientsIn = userIn.getClients();
        if (clientsIn != null) {
            for (IFrontEndClient clientIn : clientsIn) {
                FrontEndClient clientOut = this.convertToFrontEndClient(clientIn);
                clientsOutList.add(clientOut);
            }
        }
        FrontEndClient[] clientsOut = new FrontEndClient[clientsOutList.size()];
        clientsOut = clientsOutList.toArray(clientsOut);
        userOut.setclients(clientsOut);
        String roleId = this.getRoleId(userIn);
        userOut.setrole(roleId);
        UserSynthetics synthetic = this.createSynthetic(roleId, this.baseUrl);
        userOut.setsynthetic(synthetic);
        return userOut;
    }

    private String getRoleId(IUser userIn) throws InternalServletException {
        String roleId;
        if (this.rbacService.isOwner(userIn.getLoginId())) {
            try {
                Role ownerRole = this.rbacService.getRoleByName("owner");
                roleId = ownerRole.getId();
            }
            catch (RBACException ex) {
                ServletError error = new ServletError(ServletErrorMessage.GAL5124_ROLE_ID_NOT_FOUND_FOR_USER, new String[0]);
                throw new InternalServletException(error, 500);
            }
        } else {
            roleId = userIn.getRoleId();
            if (roleId == null || roleId.trim().equals("")) {
                roleId = "2";
            }
        }
        return roleId;
    }

    UserSynthetics createSynthetic(String roleId, String baseUrl) throws InternalServletException {
        Role role;
        try {
            role = this.rbacService.getRoleById(roleId);
        }
        catch (RBACException ex) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5124_ROLE_ID_NOT_FOUND_FOR_USER, new String[0]);
            throw new InternalServletException(error, 500);
        }
        RoleTransform roleXForm = new RoleTransform();
        Object url = baseUrl;
        if (!baseUrl.endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "rbac/roles/" + role.getId();
        RBACRole rbacRole = roleXForm.createRoleBean(role, (String)url);
        UserSynthetics synthetics = new UserSynthetics();
        synthetics.setrole(rbacRole);
        return synthetics;
    }

    private String calculateUrl(String userNumber) {
        Object url = this.baseUrl;
        if (this.baseUrl != null && !this.baseUrl.endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + "users/" + userNumber;
        return url;
    }

    private FrontEndClient convertToFrontEndClient(IFrontEndClient clientIn) {
        FrontEndClient clientOut = new FrontEndClient();
        clientOut.setClientName(clientIn.getClientName());
        clientOut.setLastLogin(clientIn.getLastLogin().toString());
        return clientOut;
    }
}

