/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users.internal.routes;

import dev.galasa.framework.api.beans.generated.UserData;
import dev.galasa.framework.api.beans.generated.UserUpdateData;
import dev.galasa.framework.api.common.Environment;
import dev.galasa.framework.api.common.HttpRequestContext;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.QueryParameters;
import dev.galasa.framework.api.common.ResponseBuilder;
import dev.galasa.framework.api.common.ServletError;
import dev.galasa.framework.api.common.ServletErrorMessage;
import dev.galasa.framework.api.users.internal.routes.AbstractUsersRoute;
import dev.galasa.framework.api.users.internal.routes.BeanTransformer;
import dev.galasa.framework.api.users.internal.routes.UserUpdateRequestValidator;
import dev.galasa.framework.api.users.internal.routes.UsersUrlParameterExtractor;
import dev.galasa.framework.auth.spi.IAuthService;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.auth.AuthStoreException;
import dev.galasa.framework.spi.auth.IInternalAuthToken;
import dev.galasa.framework.spi.auth.IUser;
import dev.galasa.framework.spi.rbac.BuiltInAction;
import dev.galasa.framework.spi.rbac.RBACException;
import dev.galasa.framework.spi.rbac.RBACService;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserRoute
extends AbstractUsersRoute {
    protected static final String path = "\\/([a-zA-Z0-9\\-\\_]+)\\/?";
    protected Pattern pathPattern;
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private BeanTransformer beanTransformer;
    private UserUpdateRequestValidator updateRequestValidator = new UserUpdateRequestValidator();

    public UserRoute(ResponseBuilder responseBuilder, Environment env, IAuthService authService, RBACService rbacService) {
        super(responseBuilder, path, authService, env, rbacService);
        this.pathPattern = this.getPathRegex();
        this.beanTransformer = new BeanTransformer(this.baseServletUrl, rbacService);
    }

    public HttpServletResponse handleDeleteRequest(String pathInfo, HttpRequestContext requestContext, HttpServletResponse response) throws FrameworkException {
        this.logger.info((Object)"handleDeleteRequest() entered");
        HttpServletRequest request = requestContext.getRequest();
        String requestingUserLoginId = requestContext.getUsername();
        IUser user = this.getUser(pathInfo);
        this.deleteUser(user, requestingUserLoginId);
        this.logger.info((Object)"handleDeleteRequest() exiting");
        return this.getResponseBuilder().buildResponse(request, response, 204);
    }

    public HttpServletResponse handlePutRequest(String pathInfo, HttpRequestContext requestContext, HttpServletResponse response) throws FrameworkException, IOException {
        String requestingUserLoginId = requestContext.getUsername();
        this.validateActionPermitted(BuiltInAction.USER_EDIT_OTHER, requestingUserLoginId);
        this.logger.info((Object)"handlePutRequest() entered");
        HttpServletRequest request = requestContext.getRequest();
        IUser originalUser = this.getUser(pathInfo);
        this.checkRequestHasContent(request);
        UserUpdateData updatePayload = (UserUpdateData)this.parseRequestBody(request, UserUpdateData.class);
        this.updateRequestValidator.validateUpdateRequest(updatePayload);
        IUser updatedUser = this.updateUser(originalUser, updatePayload, requestingUserLoginId);
        UserData updatedUserBean = this.beanTransformer.convertUserToUserBean(updatedUser);
        String payloadContent = gson.toJson((Object)updatedUserBean);
        HttpServletResponse filledResponse = this.getResponseBuilder().buildResponse(request, response, "application/json", payloadContent, 200);
        this.logger.info((Object)"handlePutRequest() exiting");
        return filledResponse;
    }

    public HttpServletResponse handleGetRequest(String pathInfo, QueryParameters queryParams, HttpRequestContext requestContext, HttpServletResponse response) throws FrameworkException, IOException {
        this.logger.info((Object)"handleGetRequest() entered");
        HttpServletRequest request = requestContext.getRequest();
        IUser userRecordFound = this.getUser(pathInfo);
        UserData userBean = this.beanTransformer.convertUserToUserBean(userRecordFound);
        String payloadContent = gson.toJson((Object)userBean);
        HttpServletResponse filledResponse = this.getResponseBuilder().buildResponse(request, response, "application/json", payloadContent, 200);
        this.logger.info((Object)"handleGetRequest() exiting");
        return filledResponse;
    }

    private IUser updateUser(IUser user, UserUpdateData updatePayload, String requestingUserLoginId) throws AuthStoreException, InternalServletException, RBACException {
        boolean isStoreUpdateRequired = false;
        String desiredRoleId = updatePayload.getrole();
        if (desiredRoleId != null) {
            this.validateUserIsNotUpdatingRoleOfAServiceOwner(this.rbacService, user.getLoginId());
            if (!desiredRoleId.equals(user.getRoleId())) {
                this.validateUserIsNotUpdatingTheirOwnRole(requestingUserLoginId, user);
                user.setRoleId(desiredRoleId);
                isStoreUpdateRequired = true;
            }
        }
        if (isStoreUpdateRequired) {
            this.authStoreService.updateUser(user);
            this.rbacService.invalidateUser(user.getLoginId());
        }
        return user;
    }

    private void validateUserIsNotUpdatingRoleOfAServiceOwner(RBACService rbacService, String userLoginInIdBeingUpdated) throws InternalServletException {
        if (rbacService.isOwner(userLoginInIdBeingUpdated)) {
            ServletError msg = new ServletError(ServletErrorMessage.GAL5414_USER_CANNOT_UPDATE_SERVICE_OWNER_ROLE, new String[0]);
            throw new InternalServletException(msg, 403);
        }
    }

    void validateUserIsNotUpdatingTheirOwnRole(String requestingUserLoginId, IUser userRecordBeingUpdated) throws InternalServletException {
        String loginIdBeingUpdated = userRecordBeingUpdated.getLoginId();
        if (requestingUserLoginId.equals(loginIdBeingUpdated)) {
            ServletError msg = new ServletError(ServletErrorMessage.GAL5413_USER_CANNOT_UPDATE_OWN_USER_ROLE, new String[0]);
            throw new InternalServletException(msg, 403);
        }
    }

    void checkRequestorHasPermissionToDeleteUserRecord(String loginIdToBeDeleted, String loginIdOfRequestor) throws InternalServletException {
        if (this.rbacService.isOwner(loginIdToBeDeleted)) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5089_FORBIDDEN_USER_DELETE_SERVICE_OWNER, new String[0]);
            throw new InternalServletException(error, 403);
        }
        if (loginIdToBeDeleted.equals(loginIdOfRequestor)) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5088_FORBIDDEN_USER_DELETE_THEMSELVES, new String[0]);
            throw new InternalServletException(error, 403);
        }
        this.validateActionPermitted(BuiltInAction.USER_EDIT_OTHER, loginIdOfRequestor);
    }

    private void deleteUser(IUser user, String requestingUserLoginId) throws InternalServletException {
        try {
            String loginId = user.getLoginId();
            this.checkRequestorHasPermissionToDeleteUserRecord(loginId, requestingUserLoginId);
            List tokens = this.authStoreService.getTokensByLoginId(loginId);
            for (IInternalAuthToken token : tokens) {
                this.authService.revokeToken(token.getTokenId(), requestingUserLoginId);
            }
            this.authStoreService.deleteUser(user);
            this.rbacService.invalidateUser(loginId);
            this.logger.info((Object)"The user with the given loginId was deleted OK");
        }
        catch (AuthStoreException | RBACException e) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5084_FAILED_TO_DELETE_USER, new String[0]);
            throw new InternalServletException(error, 500);
        }
    }

    private IUser getUser(String pathInfo) throws InternalServletException, AuthStoreException {
        String userNumber = this.getUserNumber(pathInfo);
        IUser user = this.authStoreService.getUser(userNumber);
        if (user == null) {
            ServletError error = new ServletError(ServletErrorMessage.GAL5083_ERROR_USER_NOT_FOUND, new String[0]);
            throw new InternalServletException(error, 404);
        }
        this.logger.info((Object)"A user with the given loginId was found OK");
        return user;
    }

    private String getUserNumber(String urlPath) throws InternalServletException {
        UsersUrlParameterExtractor parser = new UsersUrlParameterExtractor(this.pathPattern);
        return parser.getUserNumber(urlPath);
    }
}

