/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users.internal.routes;

import dev.galasa.framework.api.beans.generated.UserUpdateData;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.ServletError;
import dev.galasa.framework.api.common.ServletErrorMessage;
import dev.galasa.framework.spi.rbac.RBACRoles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserUpdateRequestValidator {
    public static final int MAX_ROLE_FIELD_LENGTH = 128;
    private Log logger = LogFactory.getLog(this.getClass());

    public void validateUpdateRequest(UserUpdateData userUpdateData) throws InternalServletException {
        String roleId = userUpdateData.getrole();
        if (roleId != null && !roleId.trim().isBlank()) {
            char[] characters;
            if (roleId.equals(RBACRoles.OWNER.getRole().getId())) {
                ServletError error = new ServletError(ServletErrorMessage.GAL5106_FORBIDDEN_USER_UPDATE_SERVICE_OWNER, new String[0]);
                throw new InternalServletException(error, 400);
            }
            boolean isRoleFieldOK = true;
            if (roleId.length() > 128) {
                this.logger.info((Object)"validateUpdateRequest() ; role field from user is too long.");
                isRoleFieldOK = false;
            }
            for (char c : characters = roleId.toCharArray()) {
                if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-') continue;
                isRoleFieldOK = false;
                break;
            }
            if (!isRoleFieldOK) {
                ServletError error = new ServletError(ServletErrorMessage.GAL5087_BAD_USER_UPDATE_FIELD_ROLE, new String[0]);
                throw new InternalServletException(error, 400);
            }
        }
    }
}

