/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.framework.api.users.internal.routes;

import dev.galasa.framework.api.beans.generated.UserData;
import dev.galasa.framework.api.common.Environment;
import dev.galasa.framework.api.common.HttpRequestContext;
import dev.galasa.framework.api.common.InternalServletException;
import dev.galasa.framework.api.common.QueryParameters;
import dev.galasa.framework.api.common.ResponseBuilder;
import dev.galasa.framework.api.common.SupportedQueryParameterNames;
import dev.galasa.framework.api.users.internal.routes.AbstractUsersRoute;
import dev.galasa.framework.api.users.internal.routes.BeanTransformer;
import dev.galasa.framework.auth.spi.IAuthService;
import dev.galasa.framework.spi.FrameworkException;
import dev.galasa.framework.spi.auth.AuthStoreException;
import dev.galasa.framework.spi.auth.IUser;
import dev.galasa.framework.spi.rbac.RBACService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UsersRoute
extends AbstractUsersRoute {
    private static final String path = "\\/?";
    public static final SupportedQueryParameterNames SUPPORTED_QUERY_PARAMETER_NAMES = new SupportedQueryParameterNames(new String[]{"loginId"});
    private BeanTransformer beanTransformer;

    public UsersRoute(ResponseBuilder responseBuilder, Environment env, IAuthService authService, RBACService rbacService) {
        super(responseBuilder, path, authService, env, rbacService);
        this.beanTransformer = new BeanTransformer(this.baseServletUrl, rbacService);
    }

    public SupportedQueryParameterNames getSupportedQueryParameterNames() {
        return SUPPORTED_QUERY_PARAMETER_NAMES;
    }

    public HttpServletResponse handleGetRequest(String pathInfo, QueryParameters queryParams, HttpRequestContext requestContext, HttpServletResponse response) throws ServletException, IOException, FrameworkException {
        this.logger.info((Object)"UserRoute: handleGetRequest() entered.");
        HttpServletRequest request = requestContext.getRequest();
        List<Object> usersList = new ArrayList();
        String loginId = queryParams.getSingleString("loginId", null);
        if (loginId != null) {
            usersList = this.getUserByLoginIdList(requestContext.getUsername(), loginId);
        } else {
            Collection users = this.authStoreService.getAllUsers();
            usersList = this.beanTransformer.convertAllUsersToUserBean(users);
        }
        String payloadContent = gson.toJson(usersList);
        return this.getResponseBuilder().buildResponse(request, response, "application/json", payloadContent, 200);
    }

    private List<UserData> getUserByLoginIdList(String requestorUsername, String loginId) throws InternalServletException, AuthStoreException {
        IUser currentUser;
        List<UserData> usersList = new ArrayList<UserData>();
        ArrayList<IUser> userDocs = new ArrayList<IUser>();
        if (loginId.equals("me")) {
            loginId = requestorUsername;
        }
        if ((currentUser = this.authStoreService.getUserByLoginId(loginId)) != null) {
            userDocs.add(currentUser);
            usersList = this.beanTransformer.convertAllUsersToUserBean(userDocs);
        }
        return usersList;
    }
}

