/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import com.google.gson.Gson;
import dev.galasa.ManagerException;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DssAdd;
import dev.galasa.framework.spi.DssSwap;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreMatchException;
import dev.galasa.framework.spi.IDssAction;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.IResourcePoolingService;
import dev.galasa.framework.spi.InsufficientResourcesAvailableException;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.framework.spi.utils.GalasaGson;
import dev.galasa.ipnetwork.spi.IIpNetworkManagerSpi;
import dev.galasa.linux.LinuxManagerException;
import dev.galasa.linux.OperatingSystem;
import dev.galasa.linux.spi.ILinuxManagerSpi;
import dev.galasa.linux.spi.ILinuxProvisionedImage;
import dev.galasa.linux.spi.ILinuxProvisioner;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackLinuxImageImpl;
import dev.galasa.openstack.manager.internal.OpenstackServerImpl;
import dev.galasa.openstack.manager.internal.OpenstackWindowsImageImpl;
import dev.galasa.openstack.manager.internal.properties.LinuxImageCapabilities;
import dev.galasa.openstack.manager.internal.properties.LinuxImages;
import dev.galasa.openstack.manager.internal.properties.MaximumInstances;
import dev.galasa.openstack.manager.internal.properties.NamePool;
import dev.galasa.openstack.manager.internal.properties.OpenStackEnabled;
import dev.galasa.openstack.manager.internal.properties.OpenStackLinuxPriority;
import dev.galasa.openstack.manager.internal.properties.OpenstackPropertiesSingleton;
import dev.galasa.openstack.manager.internal.properties.WindowsImageCapabilities;
import dev.galasa.openstack.manager.internal.properties.WindowsImages;
import dev.galasa.windows.spi.IWindowsManagerSpi;
import dev.galasa.windows.spi.IWindowsProvisionedImage;
import dev.galasa.windows.spi.IWindowsProvisioner;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class, ILinuxProvisioner.class, IWindowsProvisioner.class})
public class OpenstackManagerImpl
extends AbstractManager
implements ILinuxProvisioner,
IWindowsProvisioner {
    protected static final String NAMESPACE = "openstack";
    private static final Log logger = LogFactory.getLog(OpenstackManagerImpl.class);
    private IDynamicStatusStoreService dss;
    private IIpNetworkManagerSpi ipManager;
    private ILinuxManagerSpi linuxManager;
    private IWindowsManagerSpi windowsManager;
    private final ArrayList<OpenstackServerImpl> instances = new ArrayList();
    private CloseableHttpClient httpClient;
    private OpenstackHttpClient openstackHttpClient;
    private GalasaGson gson = new GalasaGson();

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        try {
            this.dss = framework.getDynamicStatusStoreService(NAMESPACE);
            OpenstackPropertiesSingleton.setCps(framework.getConfigurationPropertyService(NAMESPACE));
            this.openstackHttpClient = new OpenstackHttpClient(framework);
        }
        catch (Exception e) {
            throw new LinuxManagerException("Unable to request framework services", (Throwable)e);
        }
        this.httpClient = HttpClients.createDefault();
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        if (activeManagers.contains((Object)this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.ipManager = (IIpNetworkManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IIpNetworkManagerSpi.class);
        if (this.ipManager == null) {
            throw new LinuxManagerException("The IP Network Manager is not available");
        }
        this.linuxManager = (ILinuxManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, ILinuxManagerSpi.class);
        if (this.linuxManager != null) {
            this.linuxManager.registerProvisioner((ILinuxProvisioner)this);
        }
        this.windowsManager = (IWindowsManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IWindowsManagerSpi.class);
        if (this.windowsManager != null) {
            this.windowsManager.registerProvisioner((IWindowsProvisioner)this);
        }
    }

    public void provisionBuild() throws ManagerException, ResourceUnavailableException {
        for (OpenstackServerImpl instance : this.instances) {
            try {
                instance.build();
            }
            catch (ConfigurationPropertyStoreException e) {
                throw new OpenstackManagerException("Problem building OpenStack servers", e);
            }
        }
    }

    public void provisionDiscard() {
        for (OpenstackServerImpl instance : this.instances) {
            instance.discard();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ILinuxProvisionedImage provisionLinux(String tag, OperatingSystem operatingSystem, List<String> capabilities) throws OpenstackManagerException, ResourceUnavailableException {
        if (!OpenStackEnabled.get()) {
            logger.trace((Object)"OpenStack not enabled");
            return null;
        }
        if (!this.openstackHttpClient.connectToOpenstack()) {
            logger.trace((Object)"Unable to connect to OpenStack");
            return null;
        }
        logger.trace((Object)"Locating possible images that are available for selection");
        try {
            List<String> possibleImages = LinuxImages.get(operatingSystem, null);
            Iterator<String> possibleImagesIterator = possibleImages.iterator();
            block5: while (possibleImagesIterator.hasNext()) {
                String image = possibleImagesIterator.next();
                logger.trace((Object)("Checking if image " + image + " is correct for this test"));
                List<String> availableCapabilities = LinuxImageCapabilities.get(image);
                if (!availableCapabilities.isEmpty()) {
                    for (String availableCapability : availableCapabilities) {
                        logger.trace((Object)(availableCapability + " is an available capability of this image"));
                        if (!availableCapability.startsWith("+")) continue;
                        String actualAvailableCapability = availableCapability.substring(1);
                        boolean requestedCapability = false;
                        for (String choosenCapability : capabilities) {
                            if (choosenCapability.equalsIgnoreCase(actualAvailableCapability)) {
                                logger.trace((Object)("This image has an available capability " + actualAvailableCapability + " that matches a chosen capability " + choosenCapability));
                                requestedCapability = true;
                                break;
                            }
                            logger.trace((Object)("This image's available capability " + availableCapability + " is not required"));
                        }
                        if (requestedCapability) continue;
                        logger.trace((Object)"This image had no availabilie capabilities that were chosen for this test");
                        possibleImagesIterator.remove();
                        continue block5;
                    }
                }
                if (capabilities.isEmpty()) continue;
                for (String choosenCapability : capabilities) {
                    if (choosenCapability == null || choosenCapability.isEmpty()) continue;
                    boolean found = false;
                    for (String availableCapability : availableCapabilities) {
                        if (availableCapability.startsWith("+")) {
                            availableCapability = availableCapability.substring(1);
                        }
                        if (availableCapability.equalsIgnoreCase(choosenCapability)) {
                            logger.trace((Object)("This image has an available capability " + availableCapability + " that matches a required capability " + choosenCapability));
                            found = true;
                            break;
                        }
                        logger.trace((Object)("This image's available capability " + availableCapability + " is not required"));
                    }
                    if (found) continue;
                    logger.trace((Object)"This image had no available capabilities that we need so it is not possible to use");
                    possibleImagesIterator.remove();
                    continue block5;
                }
            }
            if (possibleImages.isEmpty()) {
                return null;
            }
            String selectedImage = possibleImages.get(0);
            logger.trace((Object)("The selected image for this test is " + selectedImage));
            String instanceName = this.reserveInstance();
            OpenstackLinuxImageImpl instance = new OpenstackLinuxImageImpl(this, this.openstackHttpClient, instanceName, selectedImage, tag);
            this.instances.add(instance);
            logger.info((Object)("Reserved OpenStack Linux instance " + instanceName + " with image " + selectedImage + " for tag " + tag));
            return instance;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new OpenstackManagerException("Problem accessing the CPS", e);
        }
        catch (DynamicStatusStoreException e) {
            throw new OpenstackManagerException("Problem accessing the DSS", e);
        }
        catch (InsufficientResourcesAvailableException e) {
            throw new ResourceUnavailableException("Ran out of slot names", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenstackManagerException("Processing interrupted", e);
        }
    }

    public IWindowsProvisionedImage provisionWindows(String tag, List<String> capabilities) throws OpenstackManagerException, ResourceUnavailableException {
        if (!OpenStackEnabled.get()) {
            return null;
        }
        if (!this.openstackHttpClient.connectToOpenstack()) {
            return null;
        }
        try {
            List<String> possibleImages = WindowsImages.get(null);
            if (!capabilities.isEmpty()) {
                Iterator<String> imageIterator = possibleImages.iterator();
                block5: while (imageIterator.hasNext()) {
                    String image = imageIterator.next();
                    List<String> imageCapabilities = WindowsImageCapabilities.get(image);
                    for (String requestedCapability : capabilities) {
                        if (imageCapabilities.contains(requestedCapability)) continue;
                        imageIterator.remove();
                        continue block5;
                    }
                }
            }
            if (possibleImages.isEmpty()) {
                return null;
            }
            String selectedImage = possibleImages.get(0);
            String instanceName = this.reserveInstance();
            OpenstackWindowsImageImpl instance = new OpenstackWindowsImageImpl(this, this.openstackHttpClient, instanceName, selectedImage, tag);
            this.instances.add(instance);
            logger.info((Object)("Reserved OpenStack Windows instance " + instanceName + " with image " + selectedImage + " for tag " + tag));
            return instance;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new OpenstackManagerException("Problem accessing the CPS", e);
        }
        catch (DynamicStatusStoreException e) {
            throw new OpenstackManagerException("Problem accessing the DSS", e);
        }
        catch (InsufficientResourcesAvailableException e) {
            throw new ResourceUnavailableException("Ran out of slot names", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenstackManagerException("Processing interrupted", e);
        }
    }

    @NotNull
    private String reserveInstance() throws DynamicStatusStoreException, InterruptedException, InsufficientResourcesAvailableException, ConfigurationPropertyStoreException, OpenstackManagerException {
        String runName = this.getFramework().getTestRunName();
        List<String> instanceNamePool = NamePool.get();
        IResourcePoolingService poolingService = this.getFramework().getResourcePoolingService();
        int maxInstances = MaximumInstances.get();
        int currentInstances = 0;
        String sCurrentInstances = this.dss.get("server.current.compute.instances");
        if (sCurrentInstances != null) {
            currentInstances = Integer.parseInt(sCurrentInstances);
        }
        if (maxInstances <= currentInstances) {
            throw new InsufficientResourcesAvailableException("At max slots");
        }
        Object slotNumber = null;
        slotNumber = sCurrentInstances != null ? new DssSwap("server.current.compute.instances", sCurrentInstances, Integer.toString(currentInstances)) : new DssAdd("server.current.compute.instances", Integer.toString(++currentInstances));
        ArrayList exclude = new ArrayList();
        List possibleNames = poolingService.obtainResources(instanceNamePool, exclude, 10, 1, this.dss, "compute.");
        if (possibleNames.isEmpty()) {
            throw new InsufficientResourcesAvailableException("Insufficient Compute names available");
        }
        String instanceName = "compute." + (String)possibleNames.remove(0);
        DssAdd computeId = new DssAdd(instanceName, runName);
        DssAdd runInstance = new DssAdd("run." + runName + "." + instanceName, "active");
        try {
            this.dss.performActions(new IDssAction[]{slotNumber, computeId, runInstance});
        }
        catch (DynamicStatusStoreMatchException e) {
            Thread.sleep(200 + new SecureRandom().nextInt(200));
            return this.reserveInstance();
        }
        return instanceName;
    }

    public IDynamicStatusStoreService getDSS() {
        return this.dss;
    }

    protected Gson getGson() {
        return this.gson.getGson();
    }

    protected IIpNetworkManagerSpi getIpNetworkManager() {
        return this.ipManager;
    }

    public int getLinuxPriority() {
        return OpenStackLinuxPriority.get();
    }
}

