/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.ICredentials;
import dev.galasa.ICredentialsUsernamePassword;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.utils.GalasaGson;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackToken;
import dev.galasa.openstack.manager.internal.json.Api;
import dev.galasa.openstack.manager.internal.json.Auth;
import dev.galasa.openstack.manager.internal.json.AuthTokenResponse;
import dev.galasa.openstack.manager.internal.json.AuthTokens;
import dev.galasa.openstack.manager.internal.json.Domain;
import dev.galasa.openstack.manager.internal.json.Endpoint;
import dev.galasa.openstack.manager.internal.json.Flavor;
import dev.galasa.openstack.manager.internal.json.Flavors;
import dev.galasa.openstack.manager.internal.json.Floatingip;
import dev.galasa.openstack.manager.internal.json.FloatingipRequestResponse;
import dev.galasa.openstack.manager.internal.json.Floatingips;
import dev.galasa.openstack.manager.internal.json.Identity;
import dev.galasa.openstack.manager.internal.json.Image;
import dev.galasa.openstack.manager.internal.json.Images;
import dev.galasa.openstack.manager.internal.json.Network;
import dev.galasa.openstack.manager.internal.json.Networks;
import dev.galasa.openstack.manager.internal.json.Password;
import dev.galasa.openstack.manager.internal.json.Port;
import dev.galasa.openstack.manager.internal.json.PortsResponse;
import dev.galasa.openstack.manager.internal.json.Project;
import dev.galasa.openstack.manager.internal.json.Scope;
import dev.galasa.openstack.manager.internal.json.Server;
import dev.galasa.openstack.manager.internal.json.ServerRequest;
import dev.galasa.openstack.manager.internal.json.ServerResponse;
import dev.galasa.openstack.manager.internal.json.ServersResponse;
import dev.galasa.openstack.manager.internal.json.User;
import dev.galasa.openstack.manager.internal.properties.OpenStackCredentialsId;
import dev.galasa.openstack.manager.internal.properties.OpenStackDomainName;
import dev.galasa.openstack.manager.internal.properties.OpenStackIdentityUri;
import dev.galasa.openstack.manager.internal.properties.OpenStackProjectName;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OpenstackHttpClient {
    private static final Log logger = LogFactory.getLog(OpenstackHttpClient.class);
    private final IFramework framework;
    private final CloseableHttpClient httpClient;
    private OpenstackToken openstackToken;
    private String openstackImageUri;
    private String openstackComputeUri;
    private String openstackNetworkUri;
    private GalasaGson gson = new GalasaGson();

    protected OpenstackHttpClient(IFramework framework) throws ConfigurationPropertyStoreException {
        this.framework = framework;
        this.httpClient = HttpClients.createDefault();
    }

    protected void checkToken() throws OpenstackManagerException {
        if (this.openstackToken == null || !this.openstackToken.isOk()) {
            this.openstackToken = null;
            if (!this.connectToOpenstack()) {
                throw new OpenstackManagerException("Unable to re-authenticate with the OpenStack server");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean connectToOpenstack() throws OpenstackManagerException {
        if (this.openstackToken != null) {
            return true;
        }
        try {
            String identityEndpoint = OpenStackIdentityUri.get();
            String domain = OpenStackDomainName.get();
            String project = OpenStackProjectName.get();
            if (identityEndpoint == null) {
                logger.warn((Object)"Openstack is not available due to identity property missing in CPS");
                return false;
            }
            if (domain == null) {
                logger.warn((Object)"Openstack is not available due to domain property is missing in CPS");
                return false;
            }
            if (project == null) {
                logger.warn((Object)"Openstack is not available due to project property is missing in CPS");
                return false;
            }
            String credentialsId = OpenStackCredentialsId.get();
            ICredentials credentials = null;
            try {
                credentials = this.framework.getCredentialsService().getCredentials(credentialsId);
            }
            catch (Exception e) {
                logger.warn((Object)("OpenStack is not available due to missing credentials " + credentialsId));
                return false;
            }
            if (credentials == null) {
                logger.warn((Object)"OpenStack credentials are missing");
                return false;
            }
            if (!(credentials instanceof ICredentialsUsernamePassword)) {
                logger.warn((Object)"OpenStack credentials are not a username/password");
                return false;
            }
            ICredentialsUsernamePassword usernamePassword = (ICredentialsUsernamePassword)credentials;
            AuthTokens authTokens = new AuthTokens();
            authTokens.auth = new Auth();
            authTokens.auth.identity = new Identity();
            authTokens.auth.identity.methods = new ArrayList<String>();
            authTokens.auth.identity.methods.add("password");
            authTokens.auth.identity.password = new Password();
            authTokens.auth.identity.password.user = new User();
            authTokens.auth.identity.password.user.name = usernamePassword.getUsername();
            authTokens.auth.identity.password.user.password = usernamePassword.getPassword();
            authTokens.auth.identity.password.user.domain = new Domain();
            authTokens.auth.identity.password.user.domain.name = domain;
            authTokens.auth.scope = new Scope();
            authTokens.auth.scope.project = new Project();
            authTokens.auth.scope.project.name = project;
            authTokens.auth.scope.project.domain = new Domain();
            authTokens.auth.scope.project.domain.name = domain;
            String content = this.gson.toJson((Object)authTokens);
            HttpPost post = new HttpPost(identityEndpoint + "/auth/tokens");
            StringEntity entity = new StringEntity(content, ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                StatusLine status = response.getStatusLine();
                HttpEntity responseEntity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)responseEntity);
                if (status.getStatusCode() != 201) {
                    logger.warn((Object)("OpenStack is not available due to identity responding with " + String.valueOf(status)));
                    boolean bl = false;
                    return bl;
                }
                AuthTokenResponse tokenResponse = (AuthTokenResponse)this.gson.fromJson(responseString, AuthTokenResponse.class);
                Header tokenHeader = response.getFirstHeader("X-Subject-Token");
                if (tokenHeader == null) {
                    logger.warn((Object)"OpenStack is not available due to missing X-Subject-Token");
                    boolean bl = false;
                    return bl;
                }
                this.openstackImageUri = null;
                if (tokenResponse.token != null && tokenResponse.token.catalog != null) {
                    for (Api api : tokenResponse.token.catalog) {
                        if ("image".equals(api.type)) {
                            if (api.endpoints == null) continue;
                            for (Endpoint endpoint : api.endpoints) {
                                if (!"public".equals(endpoint.endpoint_interface)) continue;
                                this.openstackImageUri = endpoint.url;
                            }
                            continue;
                        }
                        if ("compute".equals(api.type)) {
                            if (api.endpoints == null) continue;
                            for (Endpoint endpoint : api.endpoints) {
                                if (!"public".equals(endpoint.endpoint_interface)) continue;
                                this.openstackComputeUri = endpoint.url;
                            }
                            continue;
                        }
                        if (!"network".equals(api.type) || api.endpoints == null) continue;
                        for (Endpoint endpoint : api.endpoints) {
                            if (!"public".equals(endpoint.endpoint_interface)) continue;
                            this.openstackNetworkUri = endpoint.url;
                        }
                    }
                }
                if (this.openstackImageUri == null) {
                    logger.info((Object)"OpenStack is not available as some APIs are missing");
                    boolean bl = false;
                    return bl;
                }
                String tokenString = tokenHeader.getValue();
                ZonedDateTime zdt = ZonedDateTime.parse(tokenResponse.token.expires_at);
                this.openstackToken = new OpenstackToken(tokenString, zdt.toInstant());
                logger.debug((Object)"Connected to the OpenStack server");
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("OpenStack is not available due to " + e.getMessage()));
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Server findServerByName(@NotNull String serverName) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackComputeUri + "/servers");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                Server server;
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list servers failed - " + String.valueOf(status));
                }
                ServersResponse servers = (ServersResponse)this.gson.fromJson(entity, ServersResponse.class);
                if (servers == null) return null;
                if (servers.servers == null) return null;
                Iterator<Server> iterator = servers.servers.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    server = iterator.next();
                } while (!serverName.equals(server.name));
                Server server2 = server;
                return server2;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list servers ", e);
        }
    }

    public void deleteServer(Server server) throws OpenstackManagerException {
        if (server.id == null) {
            return;
        }
        try {
            this.checkToken();
            HttpDelete delete = new HttpDelete(this.openstackComputeUri + "/servers/" + server.id);
            delete.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)delete);){
                StatusLine status = response.getStatusLine();
                EntityUtils.consume((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 204) {
                    throw new OpenstackManagerException("OpenStack delete server failed - " + String.valueOf(status));
                }
            }
            return;
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to delete server ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Server getServer(String id) throws OpenstackManagerException {
        if (id == null) {
            return null;
        }
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackComputeUri + "/servers/" + id);
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() == 404) {
                    Server server = null;
                    return server;
                }
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list servers failed - " + String.valueOf(status));
                }
                ServerResponse server = (ServerResponse)this.gson.fromJson(entity, ServerResponse.class);
                if (server == null) return null;
                if (server.server == null) return null;
                Server server2 = server.server;
                return server2;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list servers ", e);
        }
    }

    public Server createServer(@NotNull ServerRequest serverRequest) throws OpenstackManagerException {
        Server server;
        block13: {
            this.checkToken();
            HttpPost get = new HttpPost(this.openstackComputeUri + "/servers");
            get.addHeader(this.openstackToken.getHeader());
            get.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)serverRequest)));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            try {
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 202) {
                    throw new OpenstackManagerException("OpenStack create server failed - " + String.valueOf(status) + "\n" + entity);
                }
                ServerResponse serverResponse = (ServerResponse)this.gson.fromJson(entity, ServerResponse.class);
                if (serverResponse.server == null) {
                    throw new OpenstackManagerException("Unexpected response from create server, server is missing:-\n" + entity);
                }
                if (serverResponse.server.id == null) {
                    throw new OpenstackManagerException("OpenStack did not return a server id");
                }
                if (serverResponse.server.adminPass == null) {
                    throw new OpenstackManagerException("OpenStack did not return a password");
                }
                server = serverResponse.server;
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OpenstackManagerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new OpenstackManagerException("Unable to create server ", e);
                }
            }
            response.close();
        }
        return server;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Floatingip findFloatingIpByName(String fipName) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackNetworkUri + "/v2.0/floatingips");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                Floatingip fip;
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list floating ips failed - " + String.valueOf(status));
                }
                Floatingips fips = (Floatingips)this.gson.fromJson(entity, Floatingips.class);
                if (fips == null) return null;
                if (fips.floatingips == null) return null;
                Iterator<Floatingip> iterator = fips.floatingips.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    fip = iterator.next();
                } while (!fipName.equals(fip.floating_ip_address));
                Floatingip floatingip = fip;
                return floatingip;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list floating ips ", e);
        }
    }

    public void deleteFloatingIp(Floatingip floatingip) throws OpenstackManagerException {
        if (floatingip.id == null) {
            return;
        }
        try {
            this.checkToken();
            HttpDelete delete = new HttpDelete(this.openstackNetworkUri + "/v2.0/floatingips/" + floatingip.id);
            delete.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)delete);){
                StatusLine status = response.getStatusLine();
                EntityUtils.consume((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 204) {
                    throw new OpenstackManagerException("OpenStack delete floatingip failed - " + String.valueOf(status));
                }
            }
            return;
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to floatingip server ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Floatingip getFloatingIp(String id) throws OpenstackManagerException {
        if (id == null) {
            return null;
        }
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackNetworkUri + "/v2.0/floatingips/" + id);
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() == 404) {
                    Floatingip floatingip = null;
                    return floatingip;
                }
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack get floatingip failed - " + String.valueOf(status));
                }
                FloatingipRequestResponse fipResponse = (FloatingipRequestResponse)this.gson.fromJson(entity, FloatingipRequestResponse.class);
                if (fipResponse == null) return null;
                if (fipResponse.floatingip == null) return null;
                Floatingip floatingip = fipResponse.floatingip;
                return floatingip;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to get floatingip ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Port retrievePort(@NotNull String deviceId) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackNetworkUri + "/v2.0/ports");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                Port port;
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list port failed - " + String.valueOf(status));
                }
                PortsResponse portsResponse = (PortsResponse)this.gson.fromJson(entity, PortsResponse.class);
                if (portsResponse == null) return null;
                if (portsResponse.ports == null) return null;
                Iterator<Port> iterator = portsResponse.ports.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    port = iterator.next();
                } while (!deviceId.equals(port.device_id));
                Port port2 = port;
                return port2;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to retrieve the server port", e);
        }
    }

    public String retrieveServerPassword(@NotNull Server server) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackComputeUri + "/servers/" + server.id + "/os-server-password");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                StatusLine status = response.getStatusLine();
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list os password failed - " + String.valueOf(status));
                }
            }
            return null;
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to retrieve the server os password", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getImageId(@NotNull String image) throws OpenstackManagerException {
        try {
            this.checkToken();
            String uri = this.openstackImageUri + "/v2/images?name=" + image;
            logger.trace((Object)("Attempting to get the image " + image + " from " + uri));
            HttpGet get = new HttpGet(uri);
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list image failed - " + String.valueOf(status));
                }
                Images images = (Images)this.gson.fromJson(entity, Images.class);
                if (images != null & images.images != null) {
                    for (Image i : images.images) {
                        if (i.name == null || i.name == "" || !image.equals(i.name)) continue;
                        logger.trace((Object)("Image " + image + " found"));
                        String string = i.id;
                        return string;
                    }
                }
            }
            logger.trace((Object)("Image " + image + " wasn't found in Openstack"));
            return null;
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list image " + image, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getFlavourId(@NotNull String flavour) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackComputeUri + "/flavors");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                Flavor f;
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list flavour failed - " + String.valueOf(status));
                }
                Flavors flavours = (Flavors)this.gson.fromJson(entity, Flavors.class);
                if (flavours == null) return null;
                if (flavours.flavors == null) return null;
                Iterator<Flavor> iterator = flavours.flavors.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    f = iterator.next();
                } while (f.name == null || !flavour.equals(f.name));
                String string = f.id;
                return string;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list flavour " + flavour, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Floatingip allocateFloatingip(Port port, Network network) throws OpenstackManagerException {
        try {
            this.checkToken();
            Floatingip fip = new Floatingip();
            fip.port_id = port.id;
            fip.floating_network_id = network.id;
            fip.description = "galasa_run=" + this.framework.getTestRunName();
            FloatingipRequestResponse fipRequest = new FloatingipRequestResponse();
            fipRequest.floatingip = fip;
            HttpPost post = new HttpPost(this.openstackNetworkUri + "/v2.0/floatingips");
            post.addHeader(this.openstackToken.getHeader());
            post.setEntity((HttpEntity)new StringEntity(this.gson.toJson((Object)fipRequest), ContentType.APPLICATION_JSON));
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);){
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 201) {
                    throw new OpenstackManagerException("OpenStack create floating ip failed - " + String.valueOf(status));
                }
                FloatingipRequestResponse fipResponse = (FloatingipRequestResponse)this.gson.fromJson(entity, FloatingipRequestResponse.class);
                if (fipResponse == null) return null;
                if (fipResponse.floatingip == null) return null;
                Floatingip floatingip = fipResponse.floatingip;
                return floatingip;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list floating ips ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Network findExternalNetwork(String externalNetwork) throws OpenstackManagerException {
        try {
            this.checkToken();
            HttpGet get = new HttpGet(this.openstackNetworkUri + "/v2.0/networks");
            get.addHeader(this.openstackToken.getHeader());
            try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
                Network network;
                StatusLine status = response.getStatusLine();
                String entity = EntityUtils.toString((HttpEntity)response.getEntity());
                if (status.getStatusCode() != 200) {
                    throw new OpenstackManagerException("OpenStack list networks failed - " + String.valueOf(status));
                }
                Networks networks = (Networks)this.gson.fromJson(entity, Networks.class);
                if (networks == null) return null;
                if (networks.networks == null) return null;
                Iterator<Network> iterator = networks.networks.iterator();
                do {
                    if (!iterator.hasNext()) return null;
                    network = iterator.next();
                } while (externalNetwork == null || !externalNetwork.equals(network.name));
                Network network2 = network;
                return network2;
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to list networks ", e);
        }
    }
}

