/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.ICredentials;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.ipnetwork.ICommandShell;
import dev.galasa.ipnetwork.IpNetworkManagerException;
import dev.galasa.linux.LinuxManagerException;
import dev.galasa.linux.spi.ILinuxProvisionedImage;
import dev.galasa.openstack.manager.OpenstackLinuxManagerException;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackManagerImpl;
import dev.galasa.openstack.manager.internal.OpenstackServerImpl;
import dev.galasa.openstack.manager.internal.json.GalasaMetadata;
import dev.galasa.openstack.manager.internal.json.SecurityGroup;
import dev.galasa.openstack.manager.internal.json.Server;
import dev.galasa.openstack.manager.internal.json.ServerRequest;
import dev.galasa.openstack.manager.internal.properties.LinuxArchivesDirectory;
import dev.galasa.openstack.manager.internal.properties.LinuxAvailablityZone;
import dev.galasa.openstack.manager.internal.properties.LinuxCredentials;
import dev.galasa.openstack.manager.internal.properties.LinuxFlavor;
import dev.galasa.openstack.manager.internal.properties.LinuxKeyPair;
import dev.galasa.openstack.manager.internal.properties.LinuxName;
import dev.galasa.openstack.manager.internal.properties.LinuxSecurityGroups;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenstackLinuxImageImpl
extends OpenstackServerImpl
implements ILinuxProvisionedImage {
    private static final Log logger = LogFactory.getLog(OpenstackLinuxImageImpl.class);
    private FileSystem fileSystem;
    private Path pathRoot;
    private Path pathTemp;
    private Path pathHome;
    private Path pathRunDirectory;

    public OpenstackLinuxImageImpl(@NotNull OpenstackManagerImpl manager, @NotNull OpenstackHttpClient openstackHttpClient, @NotNull String instanceName, @NotNull String image, @NotNull String tag) {
        super("Linux", manager, openstackHttpClient, instanceName, image, tag);
    }

    @NotNull
    public String getImageID() {
        return this.instanceName;
    }

    @NotNull
    public ICredentials getDefaultCredentials() throws LinuxManagerException {
        if (this.getIpHost() == null) {
            throw new OpenstackLinuxManagerException("Openstack instance has not been built yet");
        }
        try {
            return this.getIpHost().getDefaultCredentials();
        }
        catch (IpNetworkManagerException e) {
            throw new OpenstackLinuxManagerException("Unable to retrieve credentials", e);
        }
    }

    @Override
    @NotNull
    protected ICredentials getServerCredentials() throws OpenstackManagerException {
        try {
            return this.manager.getFramework().getCredentialsService().getCredentials(LinuxCredentials.get(this.image));
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to create credentials", e);
        }
    }

    @Override
    public void build() throws OpenstackManagerException, ConfigurationPropertyStoreException {
        logger.info((Object)("Building OpenStack Linux instance " + this.instanceName + " with image " + this.image + " for tag " + this.tag));
        String flavor = LinuxFlavor.get(this.image);
        logger.trace((Object)("The Linux flavor is " + flavor));
        String imageName = LinuxName.get(this.image);
        logger.trace((Object)("The image name is " + imageName));
        Server server = new Server();
        server.name = this.instanceName;
        server.imageRef = this.getOpenstackHttpClient().getImageId(imageName);
        server.flavorRef = this.getOpenstackHttpClient().getFlavourId(flavor);
        server.availability_zone = LinuxAvailablityZone.get(this.image);
        server.metadata = new GalasaMetadata();
        server.metadata.galasa_run = this.manager.getFramework().getTestRunName();
        server.key_name = LinuxKeyPair.get(this.image);
        List<String> groups = LinuxSecurityGroups.get(this.image);
        ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
        for (String group : groups) {
            SecurityGroup sGroup = new SecurityGroup();
            sGroup.name = group;
            securityGroups.add(sGroup);
        }
        server.security_groups = securityGroups;
        if (server.imageRef == null) {
            throw new OpenstackManagerException("Image " + this.image + " is missing in OpenStack");
        }
        if (server.flavorRef == null) {
            throw new OpenstackManagerException("Flavor " + flavor + " is missing in OpenStack");
        }
        ServerRequest serverRequest = new ServerRequest();
        serverRequest.server = server;
        this.createServer(serverRequest);
        try {
            this.fileSystem = this.manager.getIpNetworkManager().getFileSystem(this.getIpHost());
        }
        catch (IpNetworkManagerException e) {
            throw new OpenstackManagerException("Unable to create server FileSystem", e);
        }
        this.pathRoot = this.fileSystem.getPath("/", new String[0]);
        this.pathTemp = this.fileSystem.getPath("/tmp", new String[0]);
        try {
            String homeDir = this.getServerCommandShell().issueCommand("pwd");
            if (homeDir == null) {
                throw new OpenstackManagerException("Unable to determine home directory, response null");
            }
            homeDir = homeDir.replaceAll("\\r\\n?|\\n", "");
            this.pathHome = this.fileSystem.getPath(homeDir, new String[0]);
            logger.info((Object)("Home directory for linux image tagged " + this.tag + " is " + homeDir));
        }
        catch (IpNetworkManagerException e) {
            throw new OpenstackManagerException("Unable to determine home directory", e);
        }
    }

    @NotNull
    public ICommandShell getCommandShell() throws LinuxManagerException {
        return this.getServerCommandShell();
    }

    @NotNull
    public Path getRoot() throws LinuxManagerException {
        return this.pathRoot;
    }

    @NotNull
    public Path getHome() throws LinuxManagerException {
        return this.pathHome;
    }

    @NotNull
    public Path getTmp() throws LinuxManagerException {
        return this.pathTemp;
    }

    @NotNull
    public Path getRunDirectory() throws LinuxManagerException {
        if (this.pathRunDirectory != null) {
            return this.pathRunDirectory;
        }
        this.pathRunDirectory = this.pathHome.resolve(this.manager.getFramework().getTestRunName());
        try {
            Files.createDirectories(this.pathRunDirectory, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new LinuxManagerException("Unable to create the run directory on server", (Throwable)e);
        }
        return this.pathRunDirectory;
    }

    @NotNull
    public Path getArchivesDirectory() throws LinuxManagerException {
        try {
            return this.fileSystem.getPath(LinuxArchivesDirectory.get(this.getImage()), new String[0]);
        }
        catch (Exception e) {
            throw new LinuxManagerException("Problem determining archives directory", (Throwable)e);
        }
    }
}

