/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.galasa.ManagerException;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.IResourcePoolingService;
import dev.galasa.framework.spi.InsufficientResourcesAvailableException;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.ipnetwork.spi.IIpNetworkManagerSpi;
import dev.galasa.linux.LinuxManagerException;
import dev.galasa.linux.OperatingSystem;
import dev.galasa.linux.spi.ILinuxManagerSpi;
import dev.galasa.linux.spi.ILinuxProvisionedImage;
import dev.galasa.linux.spi.ILinuxProvisioner;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackLinuxImageImpl;
import dev.galasa.openstack.manager.internal.properties.LinuxImageCapabilities;
import dev.galasa.openstack.manager.internal.properties.LinuxImages;
import dev.galasa.openstack.manager.internal.properties.MaximumInstances;
import dev.galasa.openstack.manager.internal.properties.NamePool;
import dev.galasa.openstack.manager.internal.properties.OpenstackPropertiesSingleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class OpenstackManagerImpl
extends AbstractManager
implements ILinuxProvisioner {
    protected static final String NAMESPACE = "openstack";
    private static final Log logger = LogFactory.getLog(OpenstackManagerImpl.class);
    private IDynamicStatusStoreService dss;
    private IIpNetworkManagerSpi ipManager;
    private ILinuxManagerSpi linuxManager;
    private final ArrayList<OpenstackLinuxImageImpl> instances = new ArrayList();
    private CloseableHttpClient httpClient;
    private OpenstackHttpClient openstackHttpClient;
    private Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull Class<?> testClass) throws ManagerException {
        super.initialise(framework, allManagers, activeManagers, testClass);
        this.youAreRequired(allManagers, activeManagers);
        try {
            this.dss = framework.getDynamicStatusStoreService(NAMESPACE);
            OpenstackPropertiesSingleton.setCps(framework.getConfigurationPropertyService(NAMESPACE));
            this.openstackHttpClient = new OpenstackHttpClient(framework);
        }
        catch (Exception e) {
            throw new LinuxManagerException("Unable to request framework services", (Throwable)e);
        }
        this.httpClient = HttpClients.createDefault();
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers) throws ManagerException {
        if (activeManagers.contains((Object)this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.ipManager = (IIpNetworkManagerSpi)this.addDependentManager(allManagers, activeManagers, IIpNetworkManagerSpi.class);
        if (this.ipManager == null) {
            throw new LinuxManagerException("The IP Network Manager is not available");
        }
        this.linuxManager = (ILinuxManagerSpi)this.addDependentManager(allManagers, activeManagers, ILinuxManagerSpi.class);
        if (this.linuxManager != null) {
            this.linuxManager.registerProvisioner((ILinuxProvisioner)this);
        }
    }

    public void provisionBuild() throws ManagerException, ResourceUnavailableException {
        for (OpenstackLinuxImageImpl instance : this.instances) {
            try {
                instance.build();
            }
            catch (ConfigurationPropertyStoreException e) {
                throw new OpenstackManagerException("Problem building OpenStack servers", e);
            }
        }
    }

    public void provisionDiscard() {
        for (OpenstackLinuxImageImpl instance : this.instances) {
            instance.discard();
        }
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ILinuxProvisionedImage provision(String tag, OperatingSystem operatingSystem, List<String> capabilities) throws OpenstackManagerException {
        if (!this.openstackHttpClient.connectToOpenstack()) {
            return null;
        }
        try {
            List<String> possibleImages = LinuxImages.get(operatingSystem, null);
            if (!capabilities.isEmpty()) {
                Iterator<String> imageIterator = possibleImages.iterator();
                block5: while (imageIterator.hasNext()) {
                    String image = imageIterator.next();
                    List<String> imageCapabilities = LinuxImageCapabilities.get(image);
                    for (String requestedCapability : capabilities) {
                        if (imageCapabilities.contains(requestedCapability)) continue;
                        imageIterator.remove();
                        continue block5;
                    }
                }
            }
            if (possibleImages.isEmpty()) {
                return null;
            }
            String selectedImage = possibleImages.get(0);
            String instanceName = this.reserveInstance();
            if (instanceName == null) {
                return null;
            }
            OpenstackLinuxImageImpl instance = new OpenstackLinuxImageImpl(this, this.openstackHttpClient, instanceName, selectedImage, tag);
            this.instances.add(instance);
            logger.info((Object)("Reserved OpenStack Linux instance " + instanceName + " with image " + selectedImage + " for tag " + tag));
            return instance;
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new OpenstackManagerException("Problem accessing the CPS", e);
        }
        catch (DynamicStatusStoreException e) {
            throw new OpenstackManagerException("Problem accessing the DSS", e);
        }
        catch (InsufficientResourcesAvailableException e) {
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OpenstackManagerException("Processing interrupted", e);
        }
    }

    private String reserveInstance() throws DynamicStatusStoreException, InterruptedException, InsufficientResourcesAvailableException, ConfigurationPropertyStoreException, OpenstackManagerException {
        int maxInstances = MaximumInstances.get();
        int currentInstances = 0;
        String sCurrentInstances = this.dss.get("server.current.compute.instances");
        if (sCurrentInstances != null) {
            currentInstances = Integer.parseInt(sCurrentInstances);
        }
        if (maxInstances <= currentInstances) {
            return null;
        }
        if (!this.dss.putSwap("server.current.compute.instances", sCurrentInstances, Integer.toString(++currentInstances))) {
            Thread.sleep(200L);
            return this.reserveInstance();
        }
        String runName = this.getFramework().getTestRunName();
        String actualInstanceName = null;
        List<String> instanceNamePool = NamePool.get();
        IResourcePoolingService poolingService = this.getFramework().getResourcePoolingService();
        ArrayList exclude = new ArrayList();
        block0: do {
            List possibleNames = poolingService.obtainResources(instanceNamePool, exclude, 10, 1, this.dss, "compute");
            for (String possibleName : possibleNames) {
                String instanceName = "compute." + possibleName;
                HashMap<String, String> otherProps = new HashMap<String, String>();
                otherProps.put("run." + runName + "." + instanceName, "active");
                if (!this.dss.putSwap(instanceName, null, runName, otherProps)) continue;
                actualInstanceName = possibleName;
                continue block0;
            }
        } while (actualInstanceName == null);
        return actualInstanceName;
    }

    public IDynamicStatusStoreService getDSS() {
        return this.dss;
    }

    protected Gson getGson() {
        return this.gson;
    }

    protected IIpNetworkManagerSpi getIpNetworkManager() {
        return this.ipManager;
    }
}

