/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackServerImpl;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerResourceMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final OpenstackHttpClient openstackHttpClient;
    private final IDynamicStatusStoreService dss;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pattern serverPattern = Pattern.compile("^run\\.(\\w+)\\.compute\\.(\\w+)$");

    public ServerResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        this.dss = dss;
        this.openstackHttpClient = openstackHttpClient;
        this.logger.info((Object)"OpenStack Server resource monitor initialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting OpenStack Server search");
        try {
            Map computeServers = this.dss.getPrefix("run.");
            Set activeRunNames = this.framework.getFrameworkRuns().getActiveRunNames();
            for (String key : computeServers.keySet()) {
                Matcher matcher = this.serverPattern.matcher(key);
                if (!matcher.find()) continue;
                String serverName = matcher.group(2);
                String runName = matcher.group(1);
                if (activeRunNames.contains(runName)) continue;
                this.logger.info((Object)("Discarding OpenStack server " + serverName + " as run " + runName + " has gone"));
                try {
                    OpenstackServerImpl.deleteServerByName(serverName, runName, this.dss, this.openstackHttpClient);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard OpenStack server " + serverName + " for run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure during OpenStack server scan", (Throwable)e);
        }
        this.resourceManagement.resourceManagementRunSuccessful();
        this.logger.info((Object)"Finished OpenStack Server search");
    }

    public void runFinishedOrDeleted(String runName) {
        try {
            Map serverRuns = this.dss.getPrefix("run." + runName + ".");
            for (String key : serverRuns.keySet()) {
                Matcher matcher = this.serverPattern.matcher(key);
                if (!matcher.find()) continue;
                String serverName = matcher.group(2);
                this.logger.info((Object)("Discarding OpenStack server " + serverName + " as run " + runName + " has gone"));
                try {
                    OpenstackServerImpl.deleteServerByName(serverName, runName, this.dss, this.openstackHttpClient);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard OpenStack server " + serverName + " for run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to delete OpenStack Compute Server for run " + runName));
        }
    }
}

