/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackServerImpl;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FloatingIpResourceMonitor
implements Runnable {
    private final IFramework framework;
    private final IResourceManagement resourceManagement;
    private final OpenstackHttpClient openstackHttpClient;
    private final IDynamicStatusStoreService dss;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final Pattern fipPattern = Pattern.compile("^run\\.(\\w+)\\.floatingip\\.(\\w+)$");

    public FloatingIpResourceMonitor(IFramework framework, IResourceManagement resourceManagement, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        this.dss = dss;
        this.openstackHttpClient = openstackHttpClient;
        this.logger.info((Object)"OpenStack FloatingIP resource monitor initialised");
    }

    @Override
    public void run() {
        this.logger.info((Object)"Starting OpenStack FloatingIP search");
        try {
            Map computeServers = this.dss.getPrefix("run.");
            Set activeRunNames = this.framework.getFrameworkRuns().getActiveRunNames();
            for (String key : computeServers.keySet()) {
                Matcher matcher = this.fipPattern.matcher(key);
                if (!matcher.find()) continue;
                String floatingip = matcher.group(2);
                String runName = matcher.group(1);
                if (activeRunNames.contains(runName)) continue;
                this.logger.info((Object)("Discarding OpenStack FloatingIP " + floatingip + " as run " + runName + " has gone"));
                try {
                    String fip = floatingip.replaceAll("_", ".");
                    OpenstackServerImpl.deleteFloatingIpByName(fip, runName, this.dss, this.openstackHttpClient);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard OpenStack FloatingIP " + floatingip + " for run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failure during OpenStack FloatingIP scan", (Throwable)e);
        }
        this.resourceManagement.resourceManagementRunSuccessful();
        this.logger.info((Object)"Finished OpenStack FloatingIP search");
    }

    public void runFinishedOrDeleted(String runName) {
        try {
            Map fipRuns = this.dss.getPrefix("run." + runName + ".");
            for (String key : fipRuns.keySet()) {
                Matcher matcher = this.fipPattern.matcher(key);
                if (!matcher.find()) continue;
                String floatingip = matcher.group(2);
                this.logger.info((Object)("Discarding OpenStack FloatingIP " + floatingip + " as run " + runName + " has gone"));
                try {
                    String fip = floatingip.replaceAll("_", ".");
                    OpenstackServerImpl.deleteFloatingIpByName(fip, runName, this.dss, this.openstackHttpClient);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to discard OpenStack FloatingIP " + floatingip + " for run " + runName));
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to delete OpenStack FloatingIP for run " + runName));
        }
    }
}

