/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.ICredentials;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.creds.CredentialsException;
import dev.galasa.ipnetwork.ICommandShell;
import dev.galasa.ipnetwork.IIpHost;
import dev.galasa.ipnetwork.IpNetworkManagerException;
import dev.galasa.linux.LinuxManagerException;
import dev.galasa.linux.spi.ILinuxProvisionedImage;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.OpenstackIpHost;
import dev.galasa.openstack.manager.internal.OpenstackManagerImpl;
import dev.galasa.openstack.manager.internal.OpenstackServerImpl;
import dev.galasa.openstack.manager.internal.json.Floatingip;
import dev.galasa.openstack.manager.internal.json.GalasaMetadata;
import dev.galasa.openstack.manager.internal.json.Network;
import dev.galasa.openstack.manager.internal.json.Port;
import dev.galasa.openstack.manager.internal.json.Server;
import dev.galasa.openstack.manager.internal.json.ServerRequest;
import dev.galasa.openstack.manager.internal.properties.GenerateTimeout;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenstackLinuxImageImpl
extends OpenstackServerImpl
implements ILinuxProvisionedImage {
    private static final Log logger = LogFactory.getLog(OpenstackLinuxImageImpl.class);
    public final OpenstackManagerImpl manager;
    private final OpenstackHttpClient openstackHttpClient;
    public final String instanceName;
    public final String image;
    public final String tag;
    private String id;
    private String username;
    private String password;
    private String hostname;
    private Server openstackServer;
    private Port openstackPort;
    private Floatingip openstackFloatingip;
    private OpenstackIpHost ipHost;
    private ICommandShell commandShell;
    private FileSystem fileSystem;
    private Path pathRoot;
    private Path pathTemp;
    private Path pathHome;

    public OpenstackLinuxImageImpl(@NotNull OpenstackManagerImpl manager, @NotNull OpenstackHttpClient openstackHttpClient, @NotNull String instanceName, @NotNull String image, @NotNull String tag) {
        this.manager = manager;
        this.openstackHttpClient = openstackHttpClient;
        this.instanceName = instanceName;
        this.image = image;
        this.tag = tag;
    }

    @NotNull
    public String getImageID() {
        return this.instanceName;
    }

    @NotNull
    public IIpHost getIpHost() {
        return this.ipHost;
    }

    @NotNull
    public ICredentials getDefaultCredentials() throws LinuxManagerException {
        try {
            return this.manager.getFramework().getCredentialsService().getCredentials("sshgalasa");
        }
        catch (CredentialsException e) {
            throw new LinuxManagerException("Unable to obtain default credentials for openstack linux server" + this.tag, (Throwable)e);
        }
    }

    public void discard() {
        try {
            if (this.openstackServer != null) {
                try {
                    OpenstackLinuxImageImpl.deleteServer(this.openstackServer, this.openstackServer.name, this.manager.getFramework().getTestRunName(), this.manager.getDSS(), this.openstackHttpClient);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to delete the server", (Throwable)e);
                }
            }
            if (this.openstackFloatingip != null) {
                try {
                    OpenstackLinuxImageImpl.deleteFloatingIp(this.openstackFloatingip, this.openstackFloatingip.floating_ip_address, this.manager.getFramework().getTestRunName(), this.manager.getDSS(), this.openstackHttpClient);
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to delete the floating ip", (Throwable)e);
                }
            }
            logger.info((Object)("OpenStack Linux instance " + this.instanceName + " for tag " + this.tag + " has been discarded"));
        }
        catch (Exception e) {
            logger.warn((Object)("Unable to discard OpenStack Linux instance " + this.instanceName), (Throwable)e);
        }
    }

    public void build() throws OpenstackManagerException, ConfigurationPropertyStoreException {
        logger.info((Object)("Building OpenStack Linux instance " + this.instanceName + " with image " + this.image + " for tag " + this.tag));
        String flavor = "m1.small";
        int generateTimeout = GenerateTimeout.get();
        generateTimeout = 1;
        Server server = new Server();
        server.name = this.instanceName;
        server.imageRef = this.openstackHttpClient.getImageId(this.image);
        server.flavorRef = this.openstackHttpClient.getFlavourId(flavor);
        server.availability_zone = "nova";
        server.metadata = new GalasaMetadata();
        server.metadata.galasa_run = this.manager.getFramework().getTestRunName();
        server.key_name = "galasa";
        if (server.imageRef == null) {
            throw new OpenstackManagerException("Image " + this.image + " is missing in OpenStack");
        }
        if (server.flavorRef == null) {
            throw new OpenstackManagerException("Flavor " + flavor + " is missing in OpenStack");
        }
        ServerRequest serverRequest = new ServerRequest();
        serverRequest.server = server;
        try {
            this.openstackServer = this.openstackHttpClient.createServer(serverRequest);
            this.id = this.openstackServer.id;
            this.password = this.openstackServer.adminPass;
            Instant expire = Instant.now();
            expire = expire.plus((long)generateTimeout, ChronoUnit.MINUTES);
            String serverJson = "";
            String state = null;
            boolean up = false;
            while (expire.compareTo(Instant.now()) > 0) {
                Thread.sleep(5000L);
                Server checkServer = this.openstackHttpClient.getServer(this.id);
                if (checkServer != null) {
                    serverJson = this.manager.getGson().toJson((Object)checkServer);
                    if (checkServer.power_state != null) {
                        if (checkServer.power_state == 1) {
                            logger.info((Object)("OpenStack Linux instance " + this.instanceName + " has been built and is running, compute server id = " + this.openstackServer.id));
                            this.openstackServer = checkServer;
                            up = true;
                            break;
                        }
                        state = checkServer.task_state;
                    }
                }
                logger.trace((Object)("Still waiting for OpenStack Linux instance " + this.instanceName + " to be built, task=" + state));
            }
            if (!up) {
                throw new OpenstackManagerException("OpenStack failed to build the server in time, last response was:-\n" + serverJson);
            }
            this.openstackPort = this.openstackHttpClient.retrievePort(this.openstackServer.id);
            if (this.openstackPort == null) {
                throw new OpenstackManagerException("OpenStack did not allocate a port for this instance");
            }
            Network network = this.openstackHttpClient.findExternalNetwork(null);
            if (network == null) {
                throw new OpenstackManagerException("Unable to select an external network to allocate a floatingip on");
            }
            this.openstackFloatingip = this.openstackHttpClient.allocateFloatingip(this.openstackPort, network);
            logger.info((Object)("OpenStack Linux Server " + this.instanceName + " assigned IP address " + this.openstackFloatingip.floating_ip_address));
            OpenstackLinuxImageImpl.registerFloatingIp(this.manager.getDSS(), this.manager.getFramework().getTestRunName(), this.openstackFloatingip);
            this.hostname = this.openstackFloatingip.floating_ip_address;
            this.ipHost = new OpenstackIpHost(this.hostname, this.getDefaultCredentials());
            this.commandShell = this.manager.getIpNetworkManager().getCommandShell((IIpHost)this.ipHost, this.ipHost.getDefaultCredentials());
            this.fileSystem = this.manager.getIpNetworkManager().getFileSystem(this.getIpHost());
            this.pathRoot = this.fileSystem.getPath("/", new String[0]);
            this.pathTemp = this.fileSystem.getPath("/tmp", new String[0]);
            try {
                String homeDir = this.commandShell.issueCommand("pwd");
                if (homeDir == null) {
                    throw new LinuxManagerException("Unable to determine home directory, response null");
                }
                homeDir = homeDir.replaceAll("\\r\\n?|\\n", "");
                this.pathHome = this.fileSystem.getPath(homeDir, new String[0]);
                logger.info((Object)("Home directory for linux image tagged " + this.tag + " is " + homeDir));
            }
            catch (IpNetworkManagerException e) {
                throw new OpenstackManagerException("Unable to determine home directory", e);
            }
        }
        catch (OpenstackManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OpenstackManagerException("Unable to start OpenStack Linux server", e);
        }
    }

    @NotNull
    public ICommandShell getCommandShell() throws LinuxManagerException {
        return this.commandShell;
    }

    @NotNull
    public Path getRoot() throws LinuxManagerException {
        return this.pathRoot;
    }

    @NotNull
    public Path getHome() throws LinuxManagerException {
        return this.pathHome;
    }

    @NotNull
    public Path getTmp() throws LinuxManagerException {
        return this.pathTemp;
    }
}

