/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IResourceManagement;
import dev.galasa.framework.spi.IResourceManagementProvider;
import dev.galasa.framework.spi.ResourceManagerException;
import dev.galasa.openstack.manager.internal.FloatingIpResourceMonitor;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.ServerResourceMonitor;
import dev.galasa.openstack.manager.internal.properties.OpenstackPropertiesSingleton;
import java.util.concurrent.TimeUnit;
import org.osgi.service.component.annotations.Component;

@Component(service={IResourceManagementProvider.class})
public class OpenstackResourceManagement
implements IResourceManagementProvider {
    private IFramework framework;
    private IResourceManagement resourceManagement;
    private IDynamicStatusStoreService dss;
    private OpenstackHttpClient openstackHttpClient;
    private ServerResourceMonitor serverResourceMonitor;
    private FloatingIpResourceMonitor fipResourceMonitor;

    public boolean initialise(IFramework framework, IResourceManagement resourceManagement) throws ResourceManagerException {
        this.framework = framework;
        this.resourceManagement = resourceManagement;
        try {
            this.dss = this.framework.getDynamicStatusStoreService("openstack");
            OpenstackPropertiesSingleton.setCps(this.framework.getConfigurationPropertyService("openstack"));
        }
        catch (Exception e) {
            throw new ResourceManagerException("Unable to initialise OpenStack resource monitor", (Throwable)e);
        }
        try {
            this.openstackHttpClient = new OpenstackHttpClient(this.framework);
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ResourceManagerException("Unable to initialise the OpenStack HTTP Client", (Throwable)e);
        }
        this.serverResourceMonitor = new ServerResourceMonitor(framework, resourceManagement, this.dss, this.openstackHttpClient);
        this.fipResourceMonitor = new FloatingIpResourceMonitor(framework, resourceManagement, this.dss, this.openstackHttpClient);
        return true;
    }

    public void start() {
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.serverResourceMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
        this.resourceManagement.getScheduledExecutorService().scheduleWithFixedDelay(this.fipResourceMonitor, this.framework.getRandom().nextInt(20), 20L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    public void runFinishedOrDeleted(String runName) {
        this.serverResourceMonitor.runFinishedOrDeleted(runName);
        this.fipResourceMonitor.runFinishedOrDeleted(runName);
    }
}

