/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.openstack.manager.internal;

import dev.galasa.framework.spi.DynamicStatusStoreException;
import dev.galasa.framework.spi.IDynamicStatusStoreService;
import dev.galasa.openstack.manager.OpenstackManagerException;
import dev.galasa.openstack.manager.internal.OpenstackHttpClient;
import dev.galasa.openstack.manager.internal.json.Floatingip;
import dev.galasa.openstack.manager.internal.json.Server;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenstackServerImpl {
    private static final Log logger = LogFactory.getLog(OpenstackServerImpl.class);

    public static void deleteServerByName(String serverName, String runName, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) throws OpenstackManagerException {
        Server server = openstackHttpClient.findServerByName(serverName);
        OpenstackServerImpl.deleteServer(server, serverName, runName, dss, openstackHttpClient);
    }

    public static void deleteServer(Server server, String serverName, String runName, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) throws OpenstackManagerException {
        if (server != null && server.id != null) {
            openstackHttpClient.deleteServer(server);
            Instant expire = Instant.now();
            expire = expire.plus(1L, ChronoUnit.MINUTES);
            boolean deleted = false;
            while (expire.compareTo(Instant.now()) >= 0) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Wait for server delete interrupted", (Throwable)e);
                    return;
                }
                Server deletingServer = openstackHttpClient.getServer(server.id);
                if (deletingServer != null) continue;
                deleted = true;
                break;
            }
            if (!deleted) {
                logger.warn((Object)("Failed to delete an OpenStack compute server in time - " + serverName + "/" + server.id));
                return;
            }
            logger.info((Object)("Successfully deleted OpenStack compute server " + serverName + "/" + server.id));
        }
        try {
            OpenstackServerImpl.freeServerFromDss(serverName, runName, dss);
        }
        catch (Exception e) {
            logger.error((Object)"Cleanup of DSS failed", (Throwable)e);
        }
    }

    private static void freeServerFromDss(String serverName, String runName, IDynamicStatusStoreService dss) throws DynamicStatusStoreException, InterruptedException {
        String currentInstances = dss.get("server.current.compute.instances");
        int usedInstances = 0;
        if (currentInstances != null) {
            usedInstances = Integer.parseInt(currentInstances);
        }
        if (--usedInstances < 0) {
            usedInstances = 0;
        }
        String prefix = "compute." + serverName;
        HashMap<String, String> otherProps = new HashMap<String, String>();
        otherProps.put("run." + runName + "." + prefix, "free");
        if (!dss.putSwap("server.current.compute.instances", currentInstances, Integer.toString(usedInstances), otherProps)) {
            Thread.sleep(200L);
            OpenstackServerImpl.freeServerFromDss(prefix, prefix, dss);
            return;
        }
        HashSet<String> deleteProperties = new HashSet<String>();
        deleteProperties.add("run." + runName + "." + prefix);
        deleteProperties.add(prefix);
        dss.delete(deleteProperties);
    }

    public static void deleteFloatingIpByName(String fipName, String runName, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) throws OpenstackManagerException {
        Floatingip fip = openstackHttpClient.findFloatingIpByName(fipName);
        OpenstackServerImpl.deleteFloatingIp(fip, fipName, runName, dss, openstackHttpClient);
    }

    public static void deleteFloatingIp(Floatingip floatingip, String fipName, String runName, IDynamicStatusStoreService dss, OpenstackHttpClient openstackHttpClient) throws OpenstackManagerException {
        if (floatingip != null && floatingip.id != null) {
            openstackHttpClient.deleteFloatingIp(floatingip);
            Instant expire = Instant.now();
            expire = expire.plus(1L, ChronoUnit.MINUTES);
            boolean deleted = false;
            while (expire.compareTo(Instant.now()) >= 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    logger.warn((Object)"Wait for server delete interrupted", (Throwable)e);
                    return;
                }
                Floatingip deletingFip = openstackHttpClient.getFloatingIp(floatingip.id);
                if (deletingFip != null) continue;
                deleted = true;
                break;
            }
            if (!deleted) {
                logger.warn((Object)("Failed to delete an OpenStack floatingip in time - " + fipName + "/" + floatingip.id));
                return;
            }
            logger.info((Object)("Successfully deleted OpenStack floatingip " + fipName + "/" + floatingip.id));
        }
        try {
            OpenstackServerImpl.freeFloatingipFromDss(fipName, runName, dss);
        }
        catch (Exception e) {
            logger.error((Object)"Cleanup of DSS failed", (Throwable)e);
        }
    }

    private static void freeFloatingipFromDss(String fipName, String runName, IDynamicStatusStoreService dss) throws DynamicStatusStoreException, InterruptedException {
        String fipSub = fipName.replaceAll("\\.", "_");
        String prefix = "floatingip." + fipSub;
        HashSet<String> deleteProperties = new HashSet<String>();
        deleteProperties.add("run." + runName + "." + prefix);
        deleteProperties.add(prefix);
        dss.delete(deleteProperties);
    }

    protected static void registerFloatingIp(IDynamicStatusStoreService dss, String runName, Floatingip floatingIp) throws DynamicStatusStoreException {
        String fip = floatingIp.floating_ip_address.replaceAll("\\.", "_");
        String prefix = "floatingip." + fip;
        HashMap<String, String> fipProperties = new HashMap<String, String>();
        fipProperties.put("run." + runName + "." + prefix, "active");
        fipProperties.put(prefix, runName);
        dss.put(fipProperties);
    }
}

