/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.plugin.common.impl;

import dev.galasa.plugin.common.ErrorRaiser;
import dev.galasa.plugin.common.UrlCalculator;
import java.net.URL;
import java.util.Properties;

public class UrlCalculatorImpl<T extends Exception>
implements UrlCalculator<T> {
    private ErrorRaiser<T> errorRaiser;

    public UrlCalculatorImpl(ErrorRaiser<T> errorRaiser) {
        this.errorRaiser = errorRaiser;
    }

    public URL calculateTestCatalogUrl(String apiServerUrl, String testStream) throws T {
        URL testCatalogUrl = null;
        try {
            testCatalogUrl = new URL(apiServerUrl + "/testcatalog/" + testStream);
        }
        catch (Exception ex) {
            this.errorRaiser.raiseError((Throwable)ex, "Problem publishing the test catalog. Badly formed URL to the Galasa server.", new Object[0]);
        }
        return testCatalogUrl;
    }

    public String calculateApiServerUrl(Properties bootstrapProperties, URL bootstrapUrl) throws T {
        String apiServerUrl = null;
        String sTestcatalogUrl = bootstrapProperties.getProperty("framework.testcatalog.url");
        if (sTestcatalogUrl == null || sTestcatalogUrl.trim().isEmpty()) {
            String sBootstrapUrl = this.cleanUrlString(bootstrapUrl.toString());
            if (!sBootstrapUrl.endsWith("/bootstrap")) {
                this.errorRaiser.raiseError("Unable to calculate the url to the API server, the bootstrap url does not end with /bootstrap, need a framework.testcatalog.url property in the bootstrap properties.", new Object[0]);
            }
            apiServerUrl = sBootstrapUrl.substring(0, sBootstrapUrl.length() - 10);
        } else {
            if (!(sTestcatalogUrl = this.cleanUrlString(sTestcatalogUrl)).endsWith("/testcatalog")) {
                this.errorRaiser.raiseError("Unable to calculate the url to the API server, the framework.testcatalog.url does not end in /testcatalog", new Object[0]);
            }
            apiServerUrl = sTestcatalogUrl.replace("/testcatalog", "");
        }
        return apiServerUrl;
    }

    private String cleanUrlString(String uncleanUrl) {
        String url = uncleanUrl;
        if ((url = url.trim()).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

