/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.plugin.common.impl.auth;

import com.google.gson.Gson;
import dev.galasa.plugin.common.AuthenticationException;
import dev.galasa.plugin.common.AuthenticationService;
import dev.galasa.plugin.common.impl.GsonFactory;
import dev.galasa.plugin.common.impl.auth.beans.AuthError;
import dev.galasa.plugin.common.impl.auth.beans.AuthRequestPayload;
import dev.galasa.plugin.common.impl.auth.beans.AuthResponsePayload;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private static final String GALASA_TOKEN_PART_SEPARATOR = ":";
    private static final String GALASA_API_VERSION = "0.33.0";
    private URL apiServerUrl;
    private String galasaRefreshToken;
    private String galasaClientId;
    private HttpClient httpClient;

    public AuthenticationServiceImpl(URL apiServerUrl, String galasaAccessToken, HttpClient httpClient) throws AuthenticationException {
        this.validateAndStoreApiServerUrl(apiServerUrl);
        this.validateAndStoreGalasaAccessToken(galasaAccessToken);
        this.validateAndStoreHttpClient(httpClient);
    }

    private void validateAndStoreHttpClient(HttpClient httpClient) throws AuthenticationException {
        if (httpClient == null) {
            throw new AuthenticationException("Error: Program logic error. No http client supplied to AuthenticationService.");
        }
        this.httpClient = httpClient;
    }

    private void validateAndStoreApiServerUrl(URL apiServerUrl) throws AuthenticationException {
        if (apiServerUrl == null) {
            throw new AuthenticationException("Error: galasa rest api endpoint has not supplied. It is derived from the galasa bootstrap.");
        }
        this.apiServerUrl = apiServerUrl;
    }

    private void validateAndStoreGalasaAccessToken(String galasaAccessToken) throws AuthenticationException {
        if (galasaAccessToken == null) {
            throw new AuthenticationException("Error: galasa-token has not supplied. Get a galasa access token from your Galasa server.");
        }
        String[] parts = galasaAccessToken.split(GALASA_TOKEN_PART_SEPARATOR);
        if (parts.length != 2) {
            String msg = "Error: galasa-token value supplied is not a valid galasa authentication token. It should have exactly two parts, separated by a single ':' but it does not.";
            throw new AuthenticationException(msg);
        }
        this.galasaRefreshToken = parts[0];
        this.galasaClientId = parts[1];
    }

    public String getJWT() throws AuthenticationException {
        String responseBodyString;
        Gson gson = new GsonFactory().getGson();
        String authEndpointUrl = this.apiServerUrl.toString() + "/auth";
        HttpPost postRequest = this.createAuthHttpPostRequest(gson, authEndpointUrl);
        HttpResponse response = null;
        try {
            response = this.httpClient.execute((HttpUriRequest)postRequest);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Cause: {1}", authEndpointUrl, ex.getMessage());
            throw new AuthenticationException(msg, (Throwable)ex);
        }
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 400) {
            AuthError authErrorDetail = null;
            try {
                HttpEntity entity = response.getEntity();
                String responseBodyString2 = EntityUtils.toString((HttpEntity)entity);
                authErrorDetail = (AuthError)gson.fromJson(responseBodyString2, AuthError.class);
            }
            catch (Exception ex) {
                String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Response from server (''{1}'') was not OK. Could not parse the returned payload.", authEndpointUrl, statusCode);
                throw new AuthenticationException(msg);
            }
            String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Response from server (''{1}'') was not OK. Error details: code: {2}, message: {3}", authEndpointUrl, statusCode, authErrorDetail.error_code, authErrorDetail.error_message);
            throw new AuthenticationException(msg);
        }
        if (statusCode != 200) {
            String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Response from server (''{1}'') was not OK.", authEndpointUrl, statusCode);
            throw new AuthenticationException(msg);
        }
        try {
            HttpEntity entity = response.getEntity();
            responseBodyString = EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Response body parsing issue: Cause: {1}", authEndpointUrl, ex.getMessage());
            throw new AuthenticationException(msg, (Throwable)ex);
        }
        AuthResponsePayload responsePayload = (AuthResponsePayload)gson.fromJson(responseBodyString, AuthResponsePayload.class);
        String jwt = responsePayload.jwt;
        return jwt;
    }

    private HttpPost createAuthHttpPostRequest(Gson gson, String authEndpointUrl) throws AuthenticationException {
        HttpPost postRequest = new HttpPost(authEndpointUrl);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setHeader("ClientApiVersion", GALASA_API_VERSION);
        this.setAuthHttpPostRequestPayload(gson, postRequest, authEndpointUrl);
        return postRequest;
    }

    private void setAuthHttpPostRequestPayload(Gson gson, HttpPost postRequest, String authEndpointUrl) throws AuthenticationException {
        AuthRequestPayload authRequestPayload = new AuthRequestPayload();
        authRequestPayload.client_id = this.galasaClientId;
        authRequestPayload.refresh_token = this.galasaRefreshToken;
        String payloadString = gson.toJson((Object)authRequestPayload);
        try {
            StringEntity payload = new StringEntity(payloadString);
            postRequest.setEntity((HttpEntity)payload);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format("Error: Failed to turn the Galasa token into a Java Web Token (JWT) using URL ''{0}''. Cause: ", authEndpointUrl, ex.getMessage());
            throw new AuthenticationException(msg, (Throwable)ex);
        }
    }
}

