/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.plugin.common.impl;

import dev.galasa.plugin.common.BootstrapLoader;
import dev.galasa.plugin.common.ErrorRaiser;
import dev.galasa.plugin.common.WrappedLog;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.Properties;

public class BootstrapLoaderImpl<Ex extends Exception>
implements BootstrapLoader<Ex> {
    WrappedLog log;
    ErrorRaiser<Ex> errorRaiser;

    public BootstrapLoaderImpl(WrappedLog log, ErrorRaiser<Ex> errorRaiser) {
        this.log = log;
        this.errorRaiser = errorRaiser;
    }

    public Properties getBootstrapProperties(URL bootstrapUrl) throws Ex {
        Properties bootstrapProperties = new Properties();
        try {
            URLConnection connection = bootstrapUrl.openConnection();
            String msg = MessageFormat.format("execute(): URLConnection: connected to:{0}", connection.getURL().toString());
            this.log.info(msg);
            bootstrapProperties.load(connection.getInputStream());
            this.log.info("execute(): bootstrapProperties loaded: " + String.valueOf(bootstrapProperties));
        }
        catch (Exception ex) {
            this.errorRaiser.raiseError((Throwable)ex, "execute() - Unable to load bootstrap properties, Reason: {0}", new Object[]{ex.getMessage()});
        }
        return bootstrapProperties;
    }
}

