/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram.internal;

import dev.galasa.zosprogram.ZosProgramException;
import dev.galasa.zosprogram.ZosProgramManagerException;
import dev.galasa.zosprogram.internal.AbstractZosProgramCompiler;
import dev.galasa.zosprogram.internal.ZosProgramImpl;
import dev.galasa.zosprogram.internal.properties.CICSDatasetPrefix;
import dev.galasa.zosprogram.internal.properties.LanguageEnvironmentDatasetPrefix;
import dev.galasa.zosprogram.internal.properties.ProgramLanguageCompileSyslibs;
import dev.galasa.zosprogram.internal.properties.ProgramLanguageLinkSyslibs;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ZosAssemblerProgramCompiler
extends AbstractZosProgramCompiler {
    public ZosAssemblerProgramCompiler(ZosProgramImpl zosProgram) throws ZosProgramException {
        super(zosProgram);
    }

    @Override
    public Map<String, Object> buildParameters() throws ZosProgramException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            List<String> lePrefix = LanguageEnvironmentDatasetPrefix.get(this.zosProgram.getImage().getImageID());
            parameters.put("PROGRAM", this.zosProgram.getName());
            List<String> compileSyslibs = ProgramLanguageCompileSyslibs.get(this.zosProgram.getImage().getImageID(), this.zosProgram.getLanguage());
            List<String> linkSyslibs = ProgramLanguageLinkSyslibs.get(this.zosProgram.getImage().getImageID(), this.zosProgram.getLanguage());
            if (this.zosProgram.isCics()) {
                parameters.put("TYPE", this.zosProgram.getLanguage().toString() + "/CICS");
                parameters.put("ASM.PARM", "'NODECK,OBJECT,XREF(SHORT),LIST'");
                List<String> cicsPrefix = CICSDatasetPrefix.get(this.zosProgram.getImage().getImageID());
                parameters.put("TRN.STEPLIB", this.buildSteplib(cicsPrefix));
                parameters.put("ASM.SYSLIB", this.buildCompileSyslib(compileSyslibs, lePrefix, cicsPrefix));
                parameters.put("LKED.PARM", "'XREF,LET,LIST'");
                parameters.put("LKED.SYSLIB", this.buildLinkSyslib(linkSyslibs, lePrefix, cicsPrefix));
                StringBuilder sb = new StringBuilder();
                sb.append("DISP=(OLD,DELETE),DSN=&&SYSLIN");
                sb.append("\n");
                sb.append("//         DD *");
                sb.append("\n");
                sb.append("  ORDER DFHEAG\n");
                sb.append("  INCLUDE SYSLIB(DFHEAG)\n");
                sb.append("  ENTRY ++NAME++".replace("++NAME++", this.zosProgram.getName()));
                sb.append("\n");
                sb.append("  NAME ++NAME++(R)".replace("++NAME++", this.zosProgram.getName()));
                parameters.put("LKED.SYSIN", sb.toString());
            } else {
                parameters.put("TYPE", this.zosProgram.getLanguage().toString() + "/BATCH");
                parameters.put("ASM.PARM", "'NODECK,OBJECT,XREF(SHORT),LIST'");
                parameters.put("ASM.SYSLIB", this.buildCompileSyslib(compileSyslibs, lePrefix, Collections.emptyList()));
                parameters.put("LKED.PARM", "'XREF,LET,LIST'");
                parameters.put("LKED.SYSLIB", this.buildLinkSyslib(linkSyslibs, lePrefix, Collections.emptyList()));
                StringBuilder sb = new StringBuilder();
                sb.append("DISP=(OLD,DELETE),DSN=&&SYSLIN");
                sb.append("\n");
                sb.append("//         DD *");
                sb.append("\n");
                sb.append("  ENTRY ++NAME++".replace("++NAME++", this.zosProgram.getName()));
                sb.append("\n");
                sb.append("  NAME ++NAME++(R)".replace("++NAME++", this.zosProgram.getName()));
                parameters.put("LKED.SYSIN", sb.toString());
            }
            parameters.put("SYSLMOD", this.zosProgram.getLoadlib().getName());
            parameters.put("SOURCE", this.zosProgram.getProgramSource());
        }
        catch (ZosProgramManagerException e) {
            throw new ZosProgramException("Problem building compile JCL for " + String.valueOf((Object)this.zosProgram.getLanguage()) + " program " + this.zosProgram.getName(), (Throwable)((Object)e));
        }
        return parameters;
    }

    protected String buildSteplib(List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHLOAD");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    protected String buildCompileSyslib(List<String> compileSyslibs, List<String> lePrefix, List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        datasetList.add("SYS1.MACLIB");
        datasetList.add("SYS1.MODGEN");
        datasetList.addAll(compileSyslibs);
        for (String pfx : lePrefix) {
            datasetList.add(pfx + ".SCEESAMP");
        }
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHMAC");
            datasetList.add(pfx + ".SDFHSAMP");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    protected String buildLinkSyslib(List<String> linkSyslibs, List<String> lePrefix, List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        datasetList.addAll(linkSyslibs);
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHLOAD");
        }
        for (String pfx : lePrefix) {
            datasetList.add(pfx + ".SCEELKEX");
            datasetList.add(pfx + ".SCEELKED");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    @Override
    protected String getSkelName() {
        if (this.zosProgram.isCics()) {
            return "assemblerCICS.skel";
        }
        return "assemblerBatch.skel";
    }
}

