/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram.internal;

import dev.galasa.artifact.IBundleResources;
import dev.galasa.artifact.TestBundleResourceException;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zosbatch.IZosBatchJob;
import dev.galasa.zosfile.IZosDataset;
import dev.galasa.zosfile.ZosFileManagerException;
import dev.galasa.zosprogram.IZosProgram;
import dev.galasa.zosprogram.ZosProgram;
import dev.galasa.zosprogram.ZosProgramException;
import dev.galasa.zosprogram.ZosProgramManagerException;
import dev.galasa.zosprogram.internal.ZosAssemblerProgramCompiler;
import dev.galasa.zosprogram.internal.ZosCProgramCompiler;
import dev.galasa.zosprogram.internal.ZosCobolProgramCompiler;
import dev.galasa.zosprogram.internal.ZosPl1ProgramCompiler;
import dev.galasa.zosprogram.internal.ZosProgramManagerImpl;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZosProgramImpl
implements IZosProgram {
    private static final Log logger = LogFactory.getLog(ZosProgramImpl.class);
    private ZosProgramManagerImpl zosProgramManager;
    private Field field;
    private IZosImage image;
    private String name;
    private String location;
    private ZosProgram.Language language;
    private boolean cics;
    private IZosDataset loadlib;
    private String programSource;
    private IZosBatchJob compileJob;
    private boolean compile;

    public ZosProgramManagerImpl getZosProgramManager() {
        return this.zosProgramManager;
    }

    public ZosProgramImpl(ZosProgramManagerImpl zosProgramManager, Field field, String imageTag, String name, String location, ZosProgram.Language language, boolean cics, String loadlib, boolean compile) throws ZosProgramException {
        this.zosProgramManager = zosProgramManager;
        this.field = field;
        try {
            this.initalise(zosProgramManager.getZosManager().getImageForTag(imageTag), name, location, language, cics, loadlib, compile);
        }
        catch (ZosManagerException e) {
            throw new ZosProgramException(e);
        }
    }

    public ZosProgramImpl(ZosProgramManagerImpl zosProgramManager, IZosImage image, String name, String programSource, ZosProgram.Language language, boolean cics, String loadlib) throws ZosProgramException {
        this.zosProgramManager = zosProgramManager;
        this.programSource = programSource;
        this.initalise(image, name, null, language, cics, loadlib, false);
    }

    protected void initalise(IZosImage image, String name, String location, ZosProgram.Language language, boolean cics, String loadlib, boolean compile) throws ZosProgramException {
        this.image = image;
        this.name = name;
        this.location = location;
        this.language = language;
        this.cics = cics;
        this.compile = compile;
        this.setLoadlib(loadlib);
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public ZosProgram.Language getLanguage() {
        return this.language;
    }

    @Override
    public boolean isCics() {
        return this.cics;
    }

    @Override
    public IZosDataset getLoadlib() {
        return this.loadlib;
    }

    @Override
    public IZosImage getImage() {
        return this.image;
    }

    @Override
    public String getProgramSource() throws ZosProgramException {
        if (this.programSource == null) {
            this.loadProgramSource();
        }
        return this.programSource;
    }

    public String toString() {
        return "name=" + this.name + ", location=" + this.location + ", language=" + String.valueOf((Object)this.language) + ", loadlib=" + String.valueOf(this.loadlib) + ", image=" + String.valueOf(this.image);
    }

    @Override
    public IZosBatchJob getCompileJob() {
        return this.compileJob;
    }

    protected void setLoadlib(Object loadlib) throws ZosProgramException {
        if (loadlib != null) {
            if (loadlib instanceof IZosDataset) {
                this.loadlib = (IZosDataset)loadlib;
            } else {
                try {
                    this.loadlib = this.zosProgramManager.getZosFile().getZosFileHandler().newDataset((String)loadlib, this.image);
                }
                catch (ZosFileManagerException e) {
                    throw new ZosProgramException("Unable to instantiate loadlib data set object", e);
                }
            }
        }
    }

    protected void setCompileJob(IZosBatchJob compileJob) {
        this.compileJob = compileJob;
    }

    protected void loadProgramSource() throws ZosProgramException {
        IBundleResources testBundleResources = this.zosProgramManager.getTestBundleResources();
        Object sourcePath = this.getLocation() == null ? this.getName() + "." + this.getLanguage().getFileExtension() : (this.getLocation().endsWith(this.getLanguage().getFileExtension()) ? this.getLocation() : this.getLocation() + "/" + this.getName() + this.getLanguage().getFileExtension());
        try {
            logger.info((Object)("Loading source for " + String.valueOf((Object)this.getLanguage()) + " program " + this.getName() + " from " + (String)sourcePath));
            this.programSource = testBundleResources.retrieveFileAsString((String)sourcePath);
        }
        catch (TestBundleResourceException | IOException e) {
            throw new ZosProgramException("Problem loading program source", e);
        }
    }

    protected String logForField() {
        return this.getField() != null ? " for field \"" + this.getField().getName() + "\"" : "";
    }

    @Override
    public IZosProgram compile() throws ZosProgramManagerException {
        logger.info((Object)("Compile " + String.valueOf((Object)this.getLanguage()) + " program \"" + this.getName() + "\"" + this.logForField()));
        switch (this.getLanguage()) {
            case ASSEMBLER: {
                ZosAssemblerProgramCompiler assemblerProgram = new ZosAssemblerProgramCompiler(this);
                assemblerProgram.compile();
                break;
            }
            case COBOL: {
                ZosCobolProgramCompiler cobolProgram = new ZosCobolProgramCompiler(this);
                cobolProgram.compile();
                break;
            }
            case C: {
                ZosCProgramCompiler cProgram = new ZosCProgramCompiler(this);
                cProgram.compile();
                break;
            }
            case PL1: {
                ZosPl1ProgramCompiler pl1Program = new ZosPl1ProgramCompiler(this);
                pl1Program.compile();
                break;
            }
            default: {
                throw new ZosProgramManagerException("Invalid program language: " + String.valueOf((Object)this.getLanguage()));
            }
        }
        return this;
    }

    protected boolean getCompile() {
        return this.compile;
    }
}

