/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram.internal;

import dev.galasa.ManagerException;
import dev.galasa.artifact.IArtifactManager;
import dev.galasa.artifact.IBundleResources;
import dev.galasa.framework.spi.AbstractManager;
import dev.galasa.framework.spi.ConfigurationPropertyStoreException;
import dev.galasa.framework.spi.GenerateAnnotatedField;
import dev.galasa.framework.spi.IFramework;
import dev.galasa.framework.spi.IManager;
import dev.galasa.framework.spi.ResourceUnavailableException;
import dev.galasa.framework.spi.language.GalasaTest;
import dev.galasa.zos.IZosImage;
import dev.galasa.zos.ZosManagerException;
import dev.galasa.zos.spi.IZosManagerSpi;
import dev.galasa.zosbatch.IZosBatch;
import dev.galasa.zosbatch.spi.IZosBatchSpi;
import dev.galasa.zosfile.IZosDataset;
import dev.galasa.zosfile.spi.IZosFileSpi;
import dev.galasa.zosprogram.IZosProgram;
import dev.galasa.zosprogram.ZosProgram;
import dev.galasa.zosprogram.ZosProgramManagerException;
import dev.galasa.zosprogram.internal.ZosProgramImpl;
import dev.galasa.zosprogram.internal.ZosProgramManagerField;
import dev.galasa.zosprogram.internal.properties.ZosProgramPropertiesSingleton;
import dev.galasa.zosprogram.spi.IZosProgramManagerSpi;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;

@Component(service={IManager.class})
public class ZosProgramManagerImpl
extends AbstractManager
implements IZosProgramManagerSpi {
    private static final Log logger = LogFactory.getLog(ZosProgramManagerImpl.class);
    private static final String NAMESPACE = "zosprogram";
    private static final String ZOSBATCH_JOBS = "zosBatchJobs";
    private static final String PROVISIONING = "provisioning";
    private static final String PRE_TEST = "preTest";
    private IZosManagerSpi zosManager;
    private IZosBatchSpi zosBatch;
    private IZosFileSpi zosFile;
    private IArtifactManager artifactManager;
    private IBundleResources testBundleResources;
    protected IBundleResources managerBundleResources;
    private Path archivePath;
    private String runId;
    protected IZosDataset runLoadlib;
    private final LinkedHashMap<String, ZosProgramImpl> zosPrograms = new LinkedHashMap();

    protected IZosManagerSpi getZosManager() {
        return this.zosManager;
    }

    protected IZosBatchSpi getZosBatch() {
        return this.zosBatch;
    }

    protected IZosFileSpi getZosFile() {
        return this.zosFile;
    }

    protected IArtifactManager getArtifactManager() {
        return this.artifactManager;
    }

    protected IBundleResources getTestBundleResources() {
        return this.testBundleResources;
    }

    protected IBundleResources getManagerBundleResources() {
        return this.managerBundleResources;
    }

    protected Path getArchivePath() {
        return this.archivePath;
    }

    public String getRunId() {
        return this.runId;
    }

    public void initialise(@NotNull IFramework framework, @NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        List ourFields;
        super.initialise(framework, allManagers, activeManagers, galasaTest);
        try {
            ZosProgramPropertiesSingleton.setCps(framework.getConfigurationPropertyService(NAMESPACE));
        }
        catch (ConfigurationPropertyStoreException e) {
            throw new ZosProgramManagerException("Unable to request framework services", e);
        }
        if (galasaTest.isJava().booleanValue() && !(ourFields = this.findAnnotatedFields(ZosProgramManagerField.class)).isEmpty()) {
            this.youAreRequired(allManagers, activeManagers, galasaTest);
        }
        this.runId = this.getFramework().getTestRunName();
    }

    public void youAreRequired(@NotNull List<IManager> allManagers, @NotNull List<IManager> activeManagers, @NotNull GalasaTest galasaTest) throws ManagerException {
        if (activeManagers.contains(this)) {
            return;
        }
        activeManagers.add((IManager)this);
        this.zosManager = (IZosManagerSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IZosManagerSpi.class);
        if (this.zosManager == null) {
            throw new ZosProgramManagerException("The zOS Manager is not available");
        }
        this.zosBatch = (IZosBatchSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IZosBatchSpi.class);
        if (this.zosBatch == null) {
            throw new ZosProgramManagerException("The zOS Batch Manager is not available");
        }
        this.zosFile = (IZosFileSpi)this.addDependentManager(allManagers, activeManagers, galasaTest, IZosFileSpi.class);
        if (this.zosFile == null) {
            throw new ZosProgramManagerException("The zOS File Manager is not available");
        }
        this.artifactManager = (IArtifactManager)this.addDependentManager(allManagers, activeManagers, galasaTest, IArtifactManager.class);
        if (this.artifactManager == null) {
            throw new ZosProgramManagerException("The Artifact Manager is not available");
        }
    }

    public boolean areYouProvisionalDependentOn(@NotNull IManager otherManager) {
        return otherManager instanceof IZosManagerSpi;
    }

    public void provisionGenerate() throws ManagerException, ResourceUnavailableException {
        this.generateAnnotatedFields(ZosProgramManagerField.class);
    }

    public void startOfTestClass() throws ManagerException {
        this.archivePath = this.getFramework().getResultArchiveStore().getStoredArtifactsRoot().resolve(PROVISIONING).resolve(ZOSBATCH_JOBS).resolve(PRE_TEST);
        this.managerBundleResources = this.artifactManager.getBundleResources(this.getClass());
        this.testBundleResources = this.artifactManager.getBundleResources(this.getTestClass());
        for (Map.Entry<String, ZosProgramImpl> entry : this.zosPrograms.entrySet()) {
            if (entry.getValue().getCompile()) {
                entry.getValue().compile();
                continue;
            }
            logger.warn((Object)("WARNING: " + String.valueOf((Object)entry.getValue().getLanguage()) + " program \"" + entry.getValue().getName() + "\"" + entry.getValue().logForField() + " is set to \"compile = false\" and has not been compiled"));
        }
    }

    @GenerateAnnotatedField(annotation=ZosProgram.class)
    public IZosProgram generateZosProgram(Field field, List<Annotation> annotations) throws ZosProgramManagerException {
        ZosProgram annotationZosProgram = field.getAnnotation(ZosProgram.class);
        String name = ZosProgramManagerImpl.nulled((String)annotationZosProgram.name());
        String location = ZosProgramManagerImpl.nulled((String)annotationZosProgram.location());
        String tag = ZosProgramManagerImpl.defaultString((String)annotationZosProgram.imageTag(), (String)"PRIMARY").toUpperCase();
        ZosProgram.Language language = annotationZosProgram.language();
        boolean cics = annotationZosProgram.cics();
        String loadlib = ZosProgramManagerImpl.nulled((String)annotationZosProgram.loadlib());
        boolean compile = annotationZosProgram.compile();
        ZosProgramImpl zosProgram = new ZosProgramImpl(this, field, tag, name, location, language, cics, loadlib, compile);
        this.zosPrograms.put(field.getName(), zosProgram);
        return zosProgram;
    }

    @Override
    public IZosProgram newZosProgram(IZosImage image, String name, String programSource, ZosProgram.Language language, boolean cics, String loadlib) throws ZosProgramManagerException {
        return new ZosProgramImpl(this, image, name, programSource, language, cics, loadlib);
    }

    public IZosBatch getZosBatchForImage(IZosImage image) {
        return this.zosBatch.getZosBatch(image);
    }

    public IZosDataset getRunLoadlib(IZosImage image) throws ZosProgramManagerException {
        if (this.runLoadlib == null) {
            try {
                this.runLoadlib = this.zosFile.getZosFileHandler().newDataset(this.zosManager.getRunDatasetHLQ(image) + "." + this.runId + ".LOAD", image);
                if (!this.runLoadlib.exists()) {
                    this.runLoadlib.setSpace(IZosDataset.SpaceUnit.CYLINDERS, 1, 5);
                    this.runLoadlib.setRecordFormat(IZosDataset.RecordFormat.UNDEFINED);
                    this.runLoadlib.setRecordlength(0);
                    this.runLoadlib.setBlockSize(32720);
                    this.runLoadlib.setDatasetOrganization(IZosDataset.DatasetOrganization.PARTITIONED);
                    this.runLoadlib.setDatasetType(IZosDataset.DSType.LIBRARY);
                    this.runLoadlib.create();
                    this.runLoadlib.setShouldArchive(false);
                }
            }
            catch (ZosManagerException e) {
                throw new ZosProgramManagerException(e);
            }
        }
        return this.runLoadlib;
    }
}

