/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram;

import dev.galasa.framework.spi.ValidAnnotatedFields;
import dev.galasa.zosprogram.IZosProgram;
import dev.galasa.zosprogram.internal.ZosProgramManagerField;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
@ZosProgramManagerField
@ValidAnnotatedFields(value={IZosProgram.class})
public @interface ZosProgram {
    public String name();

    public String location() default "resources";

    public Language language();

    public boolean cics() default false;

    public String loadlib() default "";

    public String imageTag() default "primary";

    public boolean compile() default true;

    public static enum Language {
        COBOL(".cbl"),
        C(".c"),
        PL1(".pl1"),
        ASSEMBLER(".asm"),
        INVALID("");

        private final String extension;

        private Language(String extension) {
            this.extension = extension;
        }

        public String getFileExtension() {
            return this.extension;
        }

        public static Language fromExtension(String extension) {
            for (Language l : Language.values()) {
                if (!l.extension.equalsIgnoreCase(extension)) continue;
                return l;
            }
            throw new IllegalArgumentException("Extension " + extension + " does not match supported languages");
        }
    }
}

