/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram.internal;

import dev.galasa.zosprogram.ZosProgramException;
import dev.galasa.zosprogram.ZosProgramManagerException;
import dev.galasa.zosprogram.internal.AbstractZosProgramCompiler;
import dev.galasa.zosprogram.internal.ZosProgramImpl;
import dev.galasa.zosprogram.internal.properties.CICSDatasetPrefix;
import dev.galasa.zosprogram.internal.properties.LanguageEnvironmentDatasetPrefix;
import dev.galasa.zosprogram.internal.properties.ProgramLanguageCompileSyslibs;
import dev.galasa.zosprogram.internal.properties.ProgramLanguageDatasetPrefix;
import dev.galasa.zosprogram.internal.properties.ProgramLanguageLinkSyslibs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ZosCProgramCompiler
extends AbstractZosProgramCompiler {
    public ZosCProgramCompiler(ZosProgramImpl zosProgram) throws ZosProgramException {
        super(zosProgram);
    }

    @Override
    public Map<String, Object> buildParameters() throws ZosProgramException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            parameters.put("PROGRAM", this.zosProgram.getName());
            List<String> languagePrefix = ProgramLanguageDatasetPrefix.get(this.zosProgram.getImage().getImageID(), this.zosProgram.getLanguage());
            List<String> lePrefix = LanguageEnvironmentDatasetPrefix.get(this.zosProgram.getImage().getImageID());
            List<String> compileSyslibs = ProgramLanguageCompileSyslibs.get(this.zosProgram.getImage().getImageID(), this.zosProgram.getLanguage());
            List<String> linkSyslibs = ProgramLanguageLinkSyslibs.get(this.zosProgram.getImage().getImageID(), this.zosProgram.getLanguage());
            if (this.zosProgram.isCics()) {
                parameters.put("TYPE", this.zosProgram.getLanguage().toString() + "/CICS");
                parameters.put("C.PARM", "'SOURCE,LIST,RENT,CICS'");
                List<String> cicsPrefix = CICSDatasetPrefix.get(this.zosProgram.getImage().getImageID());
                parameters.put("C.STEPLIB", this.buildSteplib(languagePrefix, lePrefix, cicsPrefix));
                parameters.put("C.SYSLIB", this.buildCompileSyslib(compileSyslibs, lePrefix, cicsPrefix));
                parameters.put("LKED.PARM", "'AMODE=31,MAP,RENT,DYNAM=DLL,CASE=MIXED'");
                parameters.put("LKED.SYSLIB", this.buildLinkSyslib(linkSyslibs, lePrefix, cicsPrefix));
                StringBuilder sb = new StringBuilder();
                sb.append("*\n");
                sb.append("  INCLUDE SYSLIB(DFHELII)\n");
                sb.append("//         DD ");
                sb.append("DISP=(OLD,DELETE),DSN=&&SYSLIN");
                sb.append("\n");
                sb.append("//         DD *");
                sb.append("\n");
                sb.append("  NAME ++NAME++(R)".replace("++NAME++", this.zosProgram.getName()));
                parameters.put("LKED.SYSIN", sb.toString());
            } else {
                parameters.put("TYPE", this.zosProgram.getLanguage().toString() + "/BATCH");
                parameters.put("C.PARM", "'SOURCE,LIST,RENT'");
                parameters.put("C.STEPLIB", this.buildSteplib(languagePrefix, lePrefix, Collections.emptyList()));
                parameters.put("C.SYSLIB", this.buildCompileSyslib(compileSyslibs, lePrefix, Collections.emptyList()));
                parameters.put("LKED.PARM", "'AMODE=31,MAP,RENT,DYNAM=DLL,CASE=MIXED'");
                parameters.put("LKED.SYSLIB", this.buildLinkSyslib(linkSyslibs, lePrefix, Collections.emptyList()));
                StringBuilder sb = new StringBuilder();
                sb.append("DISP=(OLD,DELETE),DSN=&&SYSLIN");
                sb.append("\n");
                sb.append("//         DD *");
                sb.append("\n");
                sb.append("  NAME ++NAME++(R)".replace("++NAME++", this.zosProgram.getName()));
                parameters.put("LKED.SYSIN", sb.toString());
            }
            parameters.put("SYSLMOD", this.zosProgram.getLoadlib().getName());
            parameters.put("SOURCE", this.zosProgram.getProgramSource());
        }
        catch (ZosProgramManagerException e) {
            throw new ZosProgramException("Problem building compile JCL for " + String.valueOf((Object)this.zosProgram.getLanguage()) + " program " + this.zosProgram.getName(), (Throwable)((Object)e));
        }
        return parameters;
    }

    protected String buildSteplib(List<String> languagePrefix, List<String> lePrefix, List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        Iterator<String> it = languagePrefix.iterator();
        while (it.hasNext()) {
            datasetList.add(it.next() + ".SCCNCMP");
        }
        for (String pfx : lePrefix) {
            datasetList.add(pfx + ".SCEERUN");
            datasetList.add(pfx + ".SCEERUN2");
        }
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHLOAD");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    protected String buildCompileSyslib(List<String> compileSyslibs, List<String> lePrefix, List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        datasetList.addAll(compileSyslibs);
        for (String pfx : lePrefix) {
            datasetList.add(pfx + ".SCEESAMP");
        }
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHC370");
            datasetList.add(pfx + ".SDFHMAC");
            datasetList.add(pfx + ".SDFHSAMP");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    protected String buildLinkSyslib(List<String> linkSyslibs, List<String> lePrefix, List<String> cicsPrefix) {
        LinkedList<String> datasetList = new LinkedList<String>();
        datasetList.addAll(linkSyslibs);
        for (String pfx : cicsPrefix) {
            datasetList.add(pfx + ".SDFHLOAD");
        }
        for (String pfx : lePrefix) {
            datasetList.add(pfx + ".SCEELKEX");
            datasetList.add(pfx + ".SCEELKED");
        }
        return this.formatDatasetConcatenation(datasetList);
    }

    @Override
    protected String getSkelName() {
        return "c.skel";
    }
}

