/*
 * Decompiled with CFR 0.152.
 */
package dev.galasa.zosprogram.internal.properties;

import dev.galasa.framework.spi.IConfigurationPropertyStoreService;
import dev.galasa.zosprogram.ZosProgramManagerException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={ZosProgramPropertiesSingleton.class}, immediate=true)
public class ZosProgramPropertiesSingleton {
    private static ZosProgramPropertiesSingleton singletonInstance;
    private IConfigurationPropertyStoreService cps;

    private static void setInstance(ZosProgramPropertiesSingleton instance) {
        singletonInstance = instance;
    }

    @Activate
    public void activate() {
        ZosProgramPropertiesSingleton.setInstance(this);
    }

    @Deactivate
    public void deacivate() {
        ZosProgramPropertiesSingleton.setInstance(null);
    }

    public static IConfigurationPropertyStoreService cps() throws ZosProgramManagerException {
        if (singletonInstance != null) {
            return ZosProgramPropertiesSingleton.singletonInstance.cps;
        }
        throw new ZosProgramManagerException("Attempt to access manager CPS before it has been initialised");
    }

    public static void setCps(IConfigurationPropertyStoreService cps) throws ZosProgramManagerException {
        if (singletonInstance != null) {
            ZosProgramPropertiesSingleton.singletonInstance.cps = cps;
            return;
        }
        throw new ZosProgramManagerException("Attempt to set manager CPS before instance created");
    }
}

