/*
 * Decompiled with CFR 0.152.
 */
package dev.getelements.elements.test;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import dev.getelements.elements.rt.kryo.guice.KryoPayloadReaderWriterModule;
import dev.getelements.elements.rt.remote.Instance;
import dev.getelements.elements.rt.remote.RemoteInvokerRegistry;
import dev.getelements.elements.rt.remote.SimpleRemoteInvokerRegistry;
import dev.getelements.elements.rt.remote.guice.StaticInstanceDiscoveryServiceModule;
import dev.getelements.elements.rt.remote.jeromq.JeroMQSecurity;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQAsyncConnectionServiceModule;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQControlClientModule;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQRemoteInvokerModule;
import dev.getelements.elements.sdk.Subscription;
import dev.getelements.elements.sdk.cluster.id.InstanceId;
import dev.getelements.elements.sdk.util.LinkedPublisher;
import dev.getelements.elements.sdk.util.Publisher;
import dev.getelements.elements.test.EmbeddedInstanceContainer;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZContext;

public class JeroMQEmbeddedInstanceContainer
implements EmbeddedInstanceContainer {
    private static final Logger logger = LoggerFactory.getLogger(JeroMQEmbeddedInstanceContainer.class);
    public static final int MINIMUM_CONNECTIONS = 5;
    public static final int MAXIMUM_CONNECTIONS = 250;
    private Instance instance;
    private Injector injector;
    private final AtomicBoolean running = new AtomicBoolean();
    private ZContext zContext;
    private JeroMQSecurity jeroMQSecurity;
    private InstanceId instanceId = InstanceId.randomInstanceId();
    private final List<Module> instanceModules = new ArrayList<Module>();
    private final List<String> connectAddresses = new ArrayList<String>();
    private final Publisher<EmbeddedInstanceContainer> onClosePublisher = new LinkedPublisher();

    public JeroMQEmbeddedInstanceContainer withInstanceId(InstanceId instanceId) {
        this.checkNotRunning();
        Objects.requireNonNull(instanceId, "instanceId");
        this.instanceId = instanceId;
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withInstanceModules(Module module) {
        this.checkNotRunning();
        Objects.requireNonNull(module, "module");
        this.instanceModules.add(module);
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withInstanceModules(Module module, Module ... modules) {
        this.checkNotRunning();
        Objects.requireNonNull(module, "module");
        Objects.requireNonNull(modules, "modules");
        this.instanceModules.add(module);
        this.instanceModules.addAll(Arrays.asList(modules));
        return this;
    }

    public JeroMQEmbeddedInstanceContainer clearConnectAddresses() {
        this.checkNotRunning();
        this.connectAddresses.clear();
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withConnectAddress(String address) {
        this.checkNotRunning();
        Objects.requireNonNull(address, "address");
        this.connectAddresses.add(address);
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withConnectAddress(String address, String ... addresses) {
        this.checkNotRunning();
        Objects.requireNonNull(address, "address");
        Objects.requireNonNull(addresses, "addresses");
        this.connectAddresses.add(address);
        this.connectAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withZContext(ZContext zContext) {
        this.checkNotRunning();
        Objects.requireNonNull(zContext);
        this.zContext = zContext;
        return this;
    }

    public JeroMQEmbeddedInstanceContainer withSecurity(JeroMQSecurity jeroMQSecurity) {
        this.checkNotRunning();
        Objects.requireNonNull(jeroMQSecurity);
        this.jeroMQSecurity = jeroMQSecurity;
        return this;
    }

    protected void checkRunning() {
        if (!this.running.get()) {
            throw new IllegalStateException("Already running.");
        }
    }

    protected void checkNotRunning() {
        if (this.running.get()) {
            throw new IllegalStateException("Already running.");
        }
    }

    @Override
    public JeroMQEmbeddedInstanceContainer start() {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Already Running.");
        }
        if (this.zContext == null) {
            ZContext created = new ZContext();
            this.onClose(s -> created.close());
            this.doStart(created);
        } else {
            this.doStart(this.zContext);
        }
        return this;
    }

    protected void doStart(ZContext zContext) {
        ZContext zContextShadow = ZContext.shadow((ZContext)zContext);
        TestInstanceModule module = new TestInstanceModule(zContextShadow, this.jeroMQSecurity);
        this.injector = Guice.createInjector((Module[])new Module[]{module});
        this.instance = (Instance)this.injector.getInstance(Instance.class);
        this.instance.start();
    }

    protected void addConnectAddress(String connectAddress) {
        if (!this.connectAddresses.contains(connectAddress)) {
            this.connectAddresses.add(connectAddress);
        }
    }

    protected Injector getInjector() {
        this.checkRunning();
        return this.injector;
    }

    @Override
    public Subscription onClose(Consumer<? super EmbeddedInstanceContainer> consumer) {
        return this.onClosePublisher.subscribe(consumer);
    }

    @Override
    public void close() {
        if (this.running.compareAndSet(true, false)) {
            this.doClose();
        }
    }

    protected void doClose() {
        Instance instance = (Instance)this.injector.getInstance(Instance.class);
        try {
            instance.close();
        }
        catch (Exception ex) {
            logger.error("Error shutting down instance.", (Throwable)ex);
        }
        ZContext zContext = (ZContext)this.injector.getInstance(ZContext.class);
        try {
            zContext.close();
        }
        catch (Exception ex) {
            logger.error("Error shutting down ZContext.", (Throwable)ex);
        }
        this.onClosePublisher.publish((Object)this);
    }

    @Override
    public Instance getInstance() {
        this.checkRunning();
        return this.instance;
    }

    @Override
    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    private class TestInstanceModule
    extends AbstractModule {
        private final ZContext zContext;
        private final JeroMQSecurity jeroMQSecurity;

        private TestInstanceModule(ZContext zContext, JeroMQSecurity jeroMQSecurity) {
            this.zContext = zContext;
            this.jeroMQSecurity = jeroMQSecurity == null ? JeroMQSecurity.DEFAULT : jeroMQSecurity;
        }

        protected void configure() {
            this.bind(ZContext.class).toInstance((Object)this.zContext);
            this.bind(InstanceId.class).toInstance((Object)JeroMQEmbeddedInstanceContainer.this.instanceId);
            this.bind(JeroMQSecurity.class).toInstance((Object)this.jeroMQSecurity);
            this.bind(RemoteInvokerRegistry.class).to(SimpleRemoteInvokerRegistry.class).asEagerSingleton();
            this.install((Module)new StaticInstanceDiscoveryServiceModule().withInstanceAddresses(JeroMQEmbeddedInstanceContainer.this.connectAddresses));
            this.install((Module)new JeroMQRemoteInvokerModule().withMinimumConnections(5).withMaximumConnections(250));
            this.install((Module)new JeroMQControlClientModule());
            this.install((Module)new KryoPayloadReaderWriterModule());
            this.install((Module)new JeroMQAsyncConnectionServiceModule().withDefaultIoThreads());
            JeroMQEmbeddedInstanceContainer.this.instanceModules.forEach(x$0 -> this.install((Module)x$0));
            this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.remote.invoker.registry.report.refresh.rate.seconds")).toInstance((Object)10L);
            this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.remote.invoker.registry.report.refresh.timeout.seconds")).toInstance((Object)15L);
            this.bind(Long.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.remote.invoker.registry.report.total.refresh.timeout.seconds")).toInstance((Object)20L);
        }
    }
}

