/*
 * Decompiled with CFR 0.152.
 */
package dev.getelements.elements.test;

import com.google.inject.Module;
import dev.getelements.elements.rt.exception.MultiException;
import dev.getelements.elements.rt.remote.jeromq.JeroMQSecurity;
import dev.getelements.elements.rt.transact.JournalTransactionalResourceServicePersistenceModule;
import dev.getelements.elements.rt.transact.unix.UnixFSTransactionalPersistenceContextModule;
import dev.getelements.elements.sdk.Subscription;
import dev.getelements.elements.sdk.cluster.id.ApplicationId;
import dev.getelements.elements.sdk.util.LinkedPublisher;
import dev.getelements.elements.sdk.util.Publisher;
import dev.getelements.elements.test.EmbeddedClientInstanceContainer;
import dev.getelements.elements.test.EmbeddedInstanceContainer;
import dev.getelements.elements.test.EmbeddedTestService;
import dev.getelements.elements.test.EmbeddedWorkerInstanceContainer;
import dev.getelements.elements.test.JeroMQEmbeddedClientInstanceContainer;
import dev.getelements.elements.test.JeroMQEmbeddedWorkerInstanceContainer;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeromq.ZContext;

public class JeroMQEmbeddedTestService
implements EmbeddedTestService {
    private static final Logger logger = LoggerFactory.getLogger(JeroMQEmbeddedTestService.class);
    private ZContext zContext;
    private JeroMQEmbeddedClientInstanceContainer client;
    private JeroMQEmbeddedWorkerInstanceContainer worker;
    private JeroMQSecurity jeroMQSecurity = JeroMQSecurity.DEFAULT;
    private final AtomicBoolean running = new AtomicBoolean();
    private final Publisher<JeroMQEmbeddedTestService> onClosePublisher = new LinkedPublisher();

    public JeroMQEmbeddedTestService withClient() {
        if (this.client == null) {
            this.client = new JeroMQEmbeddedClientInstanceContainer();
        }
        return this;
    }

    public JeroMQEmbeddedTestService withWorker() {
        if (this.worker == null) {
            this.worker = new JeroMQEmbeddedWorkerInstanceContainer();
        }
        return this;
    }

    public JeroMQEmbeddedTestService withZContext(ZContext zContext) {
        this.zContext = zContext;
        return this;
    }

    public JeroMQEmbeddedTestService withSecurity(JeroMQSecurity jeroMQSecurity) {
        this.jeroMQSecurity = jeroMQSecurity;
        return this;
    }

    public JeroMQEmbeddedTestService withWorkerModule(Module module) {
        this.withWorker().worker.withInstanceModules(module);
        return this;
    }

    public JeroMQEmbeddedTestService withClientModule(Module module) {
        this.withClient().client.withInstanceModules(module);
        return this;
    }

    public JeroMQEmbeddedTestService withDefaultHttpClient() {
        this.withWorker().worker.withDefaultHttpClient();
        return this;
    }

    public JeroMQEmbeddedTestService withWorkerBindAddress(String workerBindAddress) {
        this.withWorker().worker.withBindAddress(workerBindAddress);
        return this;
    }

    public JeroMQEmbeddedWorkerInstanceContainer.ApplicationNodeBuilder<JeroMQEmbeddedTestService> withApplicationNode() {
        ApplicationId applicationId = ApplicationId.randomApplicationId();
        return this.withApplicationNode(applicationId);
    }

    public JeroMQEmbeddedWorkerInstanceContainer.ApplicationNodeBuilder<JeroMQEmbeddedTestService> withApplicationNode(String uniqueName) {
        ApplicationId applicationId = ApplicationId.forUniqueName((String)uniqueName);
        return this.withApplicationNode(applicationId);
    }

    public JeroMQEmbeddedWorkerInstanceContainer.ApplicationNodeBuilder<JeroMQEmbeddedTestService> withApplicationNode(ApplicationId applicationId) {
        return this.withWorker().worker.withApplication(applicationId, () -> this);
    }

    public JeroMQEmbeddedTestService withNodeModuleFactory(JeroMQEmbeddedWorkerInstanceContainer.NodeModuleFactory nodeModuleFactory) {
        this.withWorker().worker.withNodeModuleFactory(nodeModuleFactory);
        return this;
    }

    public JeroMQEmbeddedTestService withUnixFSWorker() {
        this.withWorker().worker.withInstanceModules((Module)new JournalTransactionalResourceServicePersistenceModule(), new Module[]{new UnixFSTransactionalPersistenceContextModule().withTestingDefaults()});
        return this;
    }

    @Override
    public EmbeddedTestService start() {
        ZContext zc;
        if (this.worker == null && this.client == null) {
            throw new IllegalStateException("Must have at least one worker or client.");
        }
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException("Already started.");
        }
        if (this.zContext == null) {
            ZContext created = zc = new ZContext();
            this.onClose(s -> created.close());
        } else {
            zc = this.zContext;
        }
        if (this.worker != null) {
            this.worker.withZContext(zc).withSecurity(this.jeroMQSecurity);
        }
        if (this.client != null) {
            this.client.withZContext(zc).withSecurity(this.jeroMQSecurity).clearConnectAddresses().withConnectAddress(this.worker.getBindAddress());
        }
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        try {
            this.getWorkerOptional().ifPresent(EmbeddedInstanceContainer::start);
        }
        catch (Exception ex) {
            exceptionList.add(ex);
            logger.error("Exception starting test worker instance.", (Throwable)ex);
        }
        try {
            this.getClientOptional().ifPresent(EmbeddedInstanceContainer::start);
        }
        catch (Exception ex) {
            exceptionList.add(ex);
            logger.error("Exception starting test client instance.", (Throwable)ex);
        }
        if (!exceptionList.isEmpty()) {
            throw new MultiException(exceptionList);
        }
        this.getWorkerOptional().ifPresent(w -> w.getInstance().refreshConnections());
        this.getClientOptional().ifPresent(c -> c.getInstance().refreshConnections());
        return this;
    }

    @Override
    public Optional<EmbeddedClientInstanceContainer> getClientOptional() {
        return Optional.ofNullable(this.client);
    }

    @Override
    public Optional<EmbeddedWorkerInstanceContainer> getWorkerOptional() {
        return Optional.of(this.worker);
    }

    @Override
    public Subscription onClose(Consumer<? super EmbeddedTestService> consumer) {
        return this.onClosePublisher.subscribe(consumer);
    }

    @Override
    public void close() {
        ArrayList<Exception> exceptionList = new ArrayList<Exception>();
        try {
            if (this.client != null) {
                this.getClient().close();
            }
        }
        catch (Exception ex) {
            exceptionList.add(ex);
            logger.error("Exception stopping test client instance.", (Throwable)ex);
        }
        try {
            if (this.client != null) {
                this.getWorker().close();
            }
        }
        catch (Exception ex) {
            exceptionList.add(ex);
            logger.error("Exception stopping test worker instance.", (Throwable)ex);
        }
        if (!exceptionList.isEmpty()) {
            throw new MultiException(exceptionList);
        }
    }
}

