/*
 * Decompiled with CFR 0.152.
 */
package dev.getelements.elements.test;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import dev.getelements.elements.rt.guice.SimpleExecutorsModule;
import dev.getelements.elements.rt.jersey.guice.JerseyHttpClientModule;
import dev.getelements.elements.rt.remote.Node;
import dev.getelements.elements.rt.remote.Worker;
import dev.getelements.elements.rt.remote.jeromq.JeroMQSecurity;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQInstanceConnectionServiceModule;
import dev.getelements.elements.sdk.ServiceLocator;
import dev.getelements.elements.sdk.cluster.id.ApplicationId;
import dev.getelements.elements.sdk.cluster.id.InstanceId;
import dev.getelements.elements.sdk.cluster.id.NodeId;
import dev.getelements.elements.test.EmbeddedWorkerInstanceContainer;
import dev.getelements.elements.test.JeroMQEmbeddedInstanceContainer;
import dev.getelements.elements.test.guice.TestApplicationNodeModule;
import dev.getelements.elements.test.guice.TestMasterNodeModule;
import dev.getelements.elements.test.guice.TestWorkerInstanceModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.zeromq.ZContext;

public class JeroMQEmbeddedWorkerInstanceContainer
extends JeroMQEmbeddedInstanceContainer
implements EmbeddedWorkerInstanceContainer {
    private final List<Module> applicationModules = new ArrayList<Module>();
    private final Map<NodeId, Injector> applicationIdInjectorMap = new LinkedHashMap<NodeId, Injector>();
    private String bindAddress = String.format("inproc://%s.worker", UUID.randomUUID());
    private final JeroMQInstanceConnectionServiceModule jeroMQInstanceConnectionServiceModule = new JeroMQInstanceConnectionServiceModule().withDefaultRefreshInterval().withBindAddress(this.bindAddress);
    private NodeModuleFactory nodeModuleFactory = applicationId -> {
        throw new UnsupportedOperationException("Node.Factory not supported: ");
    };

    public JeroMQEmbeddedWorkerInstanceContainer() {
        this.withInstanceModules((Module)new TestWorkerInstanceModule(), new Module[]{new TestMasterNodeModule(this.getInstanceId()), new SimpleExecutorsModule().withDefaultSchedulerThreads(), this.jeroMQInstanceConnectionServiceModule, new AbstractModule(){

            protected void configure() {
                Provider parent = this.getProvider(Injector.class);
                this.bind((TypeLiteral)new TypeLiteral<Set<Node>>(this){}).toProvider(() -> JeroMQEmbeddedWorkerInstanceContainer.this.loadNodes((Injector)parent.get()));
                this.bind(Node.Factory.class).toInstance(aid -> {
                    NodeId nodeId = NodeId.forInstanceAndApplication((InstanceId)JeroMQEmbeddedWorkerInstanceContainer.this.getInstanceId(), (ApplicationId)aid);
                    Collection<? extends Module> suppliedModules = JeroMQEmbeddedWorkerInstanceContainer.this.nodeModuleFactory.create(nodeId);
                    TestApplicationNodeModule module = new TestApplicationNodeModule(nodeId, suppliedModules);
                    return (Node)((Injector)parent.get()).createChildInjector(new Module[]{module}).getInstance(Node.class);
                });
            }
        }});
    }

    private Set<Node> loadNodes(Injector parent) {
        if (!this.applicationIdInjectorMap.isEmpty()) {
            throw new IllegalStateException("Expected empty map.");
        }
        LinkedHashMap applicationIdInjectorMap = this.applicationModules.stream().map(xva$0 -> parent.createChildInjector(new Module[]{xva$0})).collect(Collectors.toMap(injector -> (NodeId)injector.getInstance(NodeId.class), i -> i, (l, r) -> l, LinkedHashMap::new));
        this.applicationIdInjectorMap.putAll(applicationIdInjectorMap);
        return applicationIdInjectorMap.values().stream().map(injector -> (Node)injector.getInstance(Node.class)).collect(Collectors.toSet());
    }

    @Override
    protected void doStart(ZContext zContext) {
        this.addConnectAddress(this.bindAddress);
        super.doStart(zContext);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer clearConnectAddresses() {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.clearConnectAddresses();
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withInstanceId(InstanceId instanceId) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withInstanceId(instanceId);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withInstanceModules(Module module) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withInstanceModules(module);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withInstanceModules(Module module, Module ... modules) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withInstanceModules(module, modules);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withConnectAddress(String address) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withConnectAddress(address);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withConnectAddress(String address, String ... addresses) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withConnectAddress(address, addresses);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withZContext(ZContext zContext) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withZContext(zContext);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withSecurity(JeroMQSecurity jeroMQSecurity) {
        return (JeroMQEmbeddedWorkerInstanceContainer)super.withSecurity(jeroMQSecurity);
    }

    @Override
    public JeroMQEmbeddedWorkerInstanceContainer withDefaultHttpClient() {
        return this.withInstanceModules((Module)new JerseyHttpClientModule());
    }

    @Override
    public Worker getWorker() {
        return (Worker)this.getInjector().getInstance(Worker.class);
    }

    @Override
    public String getBindAddress() {
        return this.bindAddress;
    }

    public JeroMQEmbeddedWorkerInstanceContainer withBindAddress(String bindAddress) {
        this.checkNotRunning();
        Objects.requireNonNull(bindAddress, "bindAddress");
        this.bindAddress = bindAddress;
        this.jeroMQInstanceConnectionServiceModule.withBindAddress(this.bindAddress);
        return this;
    }

    public <ChainedT> ApplicationNodeBuilder<ChainedT> withApplication(ApplicationId applicationId, Supplier<ChainedT> chainedTSupplier) {
        return new ApplicationNodeBuilder<ChainedT>(applicationId, chainedTSupplier);
    }

    public JeroMQEmbeddedWorkerInstanceContainer withNodeModuleFactory(NodeModuleFactory nodeModuleFactory) {
        this.checkNotRunning();
        Objects.requireNonNull(nodeModuleFactory, "injectorNodeFactory");
        this.nodeModuleFactory = nodeModuleFactory;
        return this;
    }

    @Override
    protected void doClose() {
        this.applicationIdInjectorMap.clear();
        super.doClose();
    }

    @Override
    public ServiceLocator getIocResolver() {
        this.checkRunning();
        Injector injector = this.applicationIdInjectorMap.values().iterator().next();
        return (ServiceLocator)injector.getInstance(ServiceLocator.class);
    }

    @Override
    public ServiceLocator getIocResolver(NodeId nodeId) {
        this.checkRunning();
        Injector injector = this.applicationIdInjectorMap.get(nodeId);
        if (injector == null) {
            throw new IllegalArgumentException("Unknown NodeId: " + String.valueOf(nodeId));
        }
        return (ServiceLocator)injector.getInstance(ServiceLocator.class);
    }

    @FunctionalInterface
    public static interface NodeModuleFactory {
        public Collection<? extends Module> create(NodeId var1);
    }

    public class ApplicationNodeBuilder<ChainedT> {
        private final NodeId nodeId;
        private final List<Module> nodeModules = new ArrayList<Module>();
        private final Supplier<ChainedT> chainedTSupplier;

        private ApplicationNodeBuilder(ApplicationId applicationId, Supplier<ChainedT> chainedTSupplier) {
            this.nodeId = NodeId.forInstanceAndApplication((InstanceId)JeroMQEmbeddedWorkerInstanceContainer.this.getInstanceId(), (ApplicationId)applicationId);
            this.chainedTSupplier = chainedTSupplier;
        }

        public ApplicationNodeBuilder<ChainedT> withNodeModules(Module module) {
            Objects.requireNonNull(module, "module");
            this.nodeModules.add(module);
            return this;
        }

        public ApplicationNodeBuilder<ChainedT> withNodeModules(Module module, Module ... additional) {
            Objects.requireNonNull(module, "module");
            Objects.requireNonNull(additional, "additional");
            this.nodeModules.add(module);
            this.nodeModules.addAll(Arrays.asList(additional));
            return this;
        }

        public ChainedT endApplication() {
            JeroMQEmbeddedWorkerInstanceContainer.this.checkNotRunning();
            TestApplicationNodeModule module = new TestApplicationNodeModule(this.nodeId, this.nodeModules);
            JeroMQEmbeddedWorkerInstanceContainer.this.applicationModules.add((Module)module);
            return this.chainedTSupplier.get();
        }
    }
}

