/*
 * Decompiled with CFR 0.152.
 */
package dev.getelements.elements.test.guice;

import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import dev.getelements.elements.rt.guice.SimpleContextModule;
import dev.getelements.elements.rt.remote.ContextLocalInvocationDispatcher;
import dev.getelements.elements.rt.remote.LocalInvocationDispatcher;
import dev.getelements.elements.rt.remote.Node;
import dev.getelements.elements.rt.remote.RemoteInvocationDispatcher;
import dev.getelements.elements.rt.remote.SimpleRemoteInvocationDispatcher;
import dev.getelements.elements.rt.remote.guice.ClusterContextModule;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQNodeModule;
import dev.getelements.elements.rt.transact.TransactionalResourceServiceModule;
import dev.getelements.elements.rt.transact.TransactionalSchedulerContextModule;
import dev.getelements.elements.sdk.ServiceLocator;
import dev.getelements.elements.sdk.cluster.id.ApplicationId;
import dev.getelements.elements.sdk.cluster.id.NodeId;
import dev.getelements.elements.sdk.guice.GuiceServiceLocatorModule;
import dev.getelements.elements.test.guice.TestNodeServicesModule;
import java.lang.annotation.Annotation;
import java.util.Collection;

public class TestApplicationNodeModule
extends PrivateModule {
    private final NodeId nodeId;
    private final Collection<? extends Module> workerModules;

    public TestApplicationNodeModule(NodeId nodeId, Collection<? extends Module> workerModules) {
        this.nodeId = nodeId;
        this.workerModules = workerModules;
    }

    protected void configure() {
        this.expose(Node.class);
        this.expose(NodeId.class);
        this.expose(ServiceLocator.class);
        this.expose(RemoteInvocationDispatcher.class);
        this.workerModules.forEach(x$0 -> this.install((Module)x$0));
        this.install((Module)new ClusterContextModule());
        this.install((Module)new TestNodeServicesModule());
        this.install((Module)new GuiceServiceLocatorModule());
        this.install((Module)new TransactionalResourceServiceModule());
        this.install((Module)new JeroMQNodeModule().withNodeName("integration-test-node").withMinimumConnections(5).withMaximumConnections(250));
        this.bind(NodeId.class).toInstance((Object)this.nodeId);
        this.bind(ApplicationId.class).toInstance((Object)this.nodeId.getApplicationId());
        this.bind(LocalInvocationDispatcher.class).to(ContextLocalInvocationDispatcher.class).asEagerSingleton();
        this.bind(RemoteInvocationDispatcher.class).to(SimpleRemoteInvocationDispatcher.class).asEagerSingleton();
        this.install((Module)new SimpleContextModule().withDefaultContexts().withSchedulerContextModules(new Module[]{new TransactionalSchedulerContextModule()}));
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.scope")).toInstance((Object)"eci:worker");
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.protocol")).toInstance((Object)"eci:rt");
    }
}

