/*
 * Decompiled with CFR 0.152.
 */
package dev.getelements.elements.test.guice;

import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateModule;
import com.google.inject.name.Names;
import dev.getelements.elements.rt.InstanceMetadataContext;
import dev.getelements.elements.rt.guice.SimpleInstanceMetadataContextModule;
import dev.getelements.elements.rt.guice.SimpleLoadMonitorServiceModule;
import dev.getelements.elements.rt.remote.LocalInvocationDispatcher;
import dev.getelements.elements.rt.remote.MasterNodeLifecycle;
import dev.getelements.elements.rt.remote.MasterNodeLocalInvocationDispatcher;
import dev.getelements.elements.rt.remote.Node;
import dev.getelements.elements.rt.remote.NodeLifecycle;
import dev.getelements.elements.rt.remote.jeromq.guice.JeroMQNodeModule;
import dev.getelements.elements.sdk.cluster.id.InstanceId;
import dev.getelements.elements.sdk.cluster.id.NodeId;
import java.lang.annotation.Annotation;

public class TestMasterNodeModule
extends PrivateModule {
    private final NodeId nodeId;

    public TestMasterNodeModule(InstanceId instanceId) {
        this.nodeId = NodeId.forMasterNode((InstanceId)instanceId);
    }

    protected void configure() {
        this.expose(InstanceMetadataContext.class);
        this.expose(Key.get(Node.class, (Annotation)Names.named((String)"dev.getelements.elements.rt.node.master")));
        this.bind(NodeId.class).toInstance((Object)this.nodeId);
        this.install((Module)new SimpleLoadMonitorServiceModule());
        this.install((Module)new SimpleInstanceMetadataContextModule());
        this.install((Module)new JeroMQNodeModule().withAnnotation((Annotation)Names.named((String)"dev.getelements.elements.rt.node.master")).withNodeName("integration-test-master-node").withMinimumConnections(5).withMaximumConnections(250));
        this.bind(NodeLifecycle.class).to(MasterNodeLifecycle.class).asEagerSingleton();
        this.bind(LocalInvocationDispatcher.class).to(MasterNodeLocalInvocationDispatcher.class).asEagerSingleton();
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.scope")).toInstance((Object)"eci:master");
        this.bind(String.class).annotatedWith((Annotation)Names.named((String)"dev.getelements.elements.rt.protocol")).toInstance((Object)"eci:rt");
    }
}

