/*
 * Decompiled with CFR 0.152.
 */
package api.exchange.module;

import api.exchange.bean.Order;
import api.exchange.bean.OrderDetail;
import api.exchange.bean.OrderInfo;
import api.exchange.module.AuthApi;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.UUID;
import util.bean.UpbitResponse;
import util.constant.ApiList;
import util.module.Util;

public class OrdersApi
extends AuthApi {
    public OrdersApi(String api, String secret) {
        super(api, secret);
    }

    public UpbitResponse<OrderInfo> getOrderInfo(String market) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        URL url = new URL(Util.builder(ApiList.ORDERS.getUrl(), "/chance?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<OrderInfo> response = new UpbitResponse<OrderInfo>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            OrderInfo orderInfo = (OrderInfo)new Gson().fromJson(responseBuilder.toString(), OrderInfo.class);
            response.setSuccess(true);
            response.setBody(orderInfo);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<OrderDetail> getOrder(String uuid) throws IOException, NoSuchAlgorithmException {
        return this.getOrder(uuid, "");
    }

    public UpbitResponse<OrderDetail> getOrder(String uuid, String identifier) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uuid);
        params.put("identifier", identifier);
        URL url = new URL(Util.builder(ApiList.ORDER.getUrl(), "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<OrderDetail> response = new UpbitResponse<OrderDetail>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            OrderDetail orderDetail = (OrderDetail)new Gson().fromJson(responseBuilder.toString(), OrderDetail.class);
            response.setSuccess(true);
            response.setBody(orderDetail);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Order[]> getOrderLists() throws IOException, NoSuchAlgorithmException {
        String[] temp = new String[]{};
        return this.getOrderLists("", temp, temp, "wait", temp, 1, 100, "desc");
    }

    public UpbitResponse<Order[]> getOrderLists(String market, String state) throws IOException, NoSuchAlgorithmException {
        String[] temp = new String[]{};
        return this.getOrderLists(market, temp, temp, state, temp, 1, 100, "desc");
    }

    public UpbitResponse<Order[]> getOrderLists(String market, String[] uuids, String[] identifiers, String state, String[] states, int page, int limit, String order_by) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("state", state);
        params.put("page", String.valueOf(page));
        params.put("limit", String.valueOf(limit));
        params.put("order_by", order_by);
        String statesQuery = states.length > 0 ? Util.builder("&states=", String.join((CharSequence)"&states=", states)) : "";
        String uuidsQuery = uuids.length > 0 ? Util.builder("&uuids=", String.join((CharSequence)"&uuids=", uuids)) : "";
        String identifiersQuery = identifiers.length > 0 ? Util.builder("&identifiers=", String.join((CharSequence)"&identifiers=", identifiers)) : "";
        String query = Util.builder(Util.queryBuilder(params), statesQuery, uuidsQuery, identifiersQuery);
        URL url = new URL(Util.builder(ApiList.ORDERS.getUrl(), "?", query));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(query)));
        UpbitResponse<Order[]> response = new UpbitResponse<Order[]>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Order[] order = (Order[])new Gson().fromJson(responseBuilder.toString(), Order[].class);
            response.setSuccess(true);
            response.setBody(order);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Order> deleteOrder(String uuid) throws IOException, NoSuchAlgorithmException {
        return this.deleteOrder(uuid, "");
    }

    public UpbitResponse<Order> deleteOrder(String uuid, String identifier) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", uuid);
        params.put("identifier", identifier);
        URL url = new URL(Util.builder(ApiList.ORDER.getUrl(), "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<Order> response = new UpbitResponse<Order>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 200) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Order order = (Order)new Gson().fromJson(responseBuilder.toString(), Order.class);
            response.setSuccess(true);
            response.setBody(order);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Order> postSellOrder(String market, int volume) throws IOException, NoSuchAlgorithmException {
        return this.postSellOrder(market, volume, UUID.randomUUID().toString());
    }

    public UpbitResponse<Order> postSellOrder(String market, int volume, String identifier) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("side", "ask");
        params.put("volume", String.valueOf(volume));
        params.put("ord_type", "market");
        params.put("identifier", identifier);
        URL url = new URL(Util.builder(ApiList.ORDERS.getUrl(), "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<Order> response = new UpbitResponse<Order>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 201) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Order order = (Order)new Gson().fromJson(responseBuilder.toString(), Order.class);
            response.setSuccess(true);
            response.setBody(order);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Order> postBuyOrder(String market, int price) throws IOException, NoSuchAlgorithmException {
        return this.postBuyOrder(market, price, UUID.randomUUID().toString());
    }

    public UpbitResponse<Order> postBuyOrder(String market, int price, String identifier) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("side", "bid");
        params.put("price", String.valueOf(price));
        params.put("ord_type", "price");
        params.put("identifier", identifier);
        URL url = new URL(Util.builder(ApiList.ORDERS.getUrl(), "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<Order> response = new UpbitResponse<Order>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 201) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Order order = (Order)new Gson().fromJson(responseBuilder.toString(), Order.class);
            response.setSuccess(true);
            response.setBody(order);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }

    public UpbitResponse<Order> postLimitOrder(String market, String side, int volume, int price, String identifier) throws IOException, NoSuchAlgorithmException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("market", market);
        params.put("side", side);
        params.put("volume", String.valueOf(volume));
        params.put("price", String.valueOf(price));
        params.put("ord_type", "limit");
        params.put("identifier", identifier);
        URL url = new URL(Util.builder(ApiList.ORDERS.getUrl(), "?", Util.queryBuilder(params)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Authorization", Util.builder("Bearer ", this.getAuthToken(params)));
        UpbitResponse<Order> response = new UpbitResponse<Order>();
        int code = connection.getResponseCode();
        response.setStatus(code);
        if (code == 201) {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            reader.close();
            Order order = (Order)new Gson().fromJson(responseBuilder.toString(), Order.class);
            response.setSuccess(true);
            response.setBody(order);
            response.setRaw(responseBuilder.toString());
        } else {
            String temp;
            BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
            StringBuilder responseBuilder = new StringBuilder();
            while ((temp = reader.readLine()) != null) {
                responseBuilder.append(temp);
            }
            JsonObject object = (JsonObject)new Gson().fromJson(responseBuilder.toString(), JsonObject.class);
            response.setSuccess(false);
            response.setRaw(responseBuilder.toString());
            response.setError(object.getAsJsonObject("error").get("name").getAsString());
            response.setErrorMessage(object.getAsJsonObject("error").get("message").getAsString());
        }
        connection.disconnect();
        return response;
    }
}

